% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{LayoutJson}
\alias{LayoutJson}
\title{Format LogEvents as JSON}
\description{
Format a LogEvent as JSON
}
\section{Usage}{
\preformatted{
x <- LayoutJson$new(toJSON_args = list(auto_unbox = TRUE))

x$clone(deep = FALSE)
x$format_event(event)
x$set_toJSON_args(x)

x$toJSON_args

}
}

\section{Creating a New Layout}{




Layouts are instantiated with \code{<LayoutSubclass>$new()}. For a description of
the arguments to this function please refer to the Fields section.
}

\section{Fields}{

\describe{
\item{\code{toJSON_args}, \code{set_toJSON_args()}}{a list of values passed on to
\code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}
}
}
}

\section{Methods}{




\describe{
\item{\code{format_event(event)}}{format a \link{LogEvent}}
}
}

\examples{
# setup a dummy LogEvent

event <- LogEvent$new(
  logger = Logger$new("dummy logger"),
  level = 200,
  timestamp = Sys.time(),
  caller = NA_character_,
  msg = "a test message",
  custom_field = "LayoutJson can handle arbitrary fields"
)

# Default settings show all event fals
lo <- LayoutJson$new()
lo$format_event(event)

}
\seealso{
\code{\link[=read_json_lines]{read_json_lines()}}, \url{http://jsonlines.org/}

Other Layouts: \code{\link{LayoutDbi}},
  \code{\link{LayoutFormat}}, \code{\link{LayoutGlue}},
  \code{\link{Layout}}
}
\concept{Layouts}
