% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_estimation.R
\name{dlg_trivariate}
\alias{dlg_trivariate}
\title{Trivariate density estimation}
\usage{
dlg_trivariate(x, eval_points = NULL, grid_size = 15, bw = c(1, 1,
  1), est_method = "trivariate", run_checks = TRUE)
}
\arguments{
\item{x}{The data matrix (or data frame). Must have exactly 2 columns.}

\item{eval_points}{The grid where the density should be estimated. Must have
exactly 2 columns.}

\item{grid_size}{If \code{eval_points} is not supplied, then the function
will create a suitable grid diagonally through the data, with this many
grid points.}

\item{bw}{The two bandwidths, a numeric vector of length 2.}

\item{est_method}{The estimation method, must either be "1par" for estimation
with just the local correlation, or "5par"  for a full locally Gaussian fit
with all 5 parameters.}

\item{run_checks}{Logical. Should sanity checks be run on the arguments?
Useful to disable this when doing cross-validation for example.}
}
\value{
A list including the data set \code{$x}, the grid
  \code{$eval_points}, the bandwidths \code{$bw}, as well as a matrix of the
  estimated parameter estimates \code{$par_est} and the estimated bivariate
  density \code{$f_est}.
}
\description{
\code{dlg_trivariate} returns the locally Gaussian density estimate of a
trivariate distribution on a given grid.
}
\details{
In some applications it may be desired to produce a full locally Gaussian fit
of a trivariate density function without having to resort to bivariate
approximations. This function takes a trivariate data set, \code{x}, and a
trivariate set of grid points \code{eval_points}, and returns the trivariate,
locally Gaussian density estimate in these points. We also need a vector of
bandwidths, \code{bw}, with three elements, and an estimation method
\code{est_method}, which in this case is fixed at "trivariate", and
included only to be fully compatible with the other methods in this package.

This function will only work on the marginally standard normal scale! Please
use the wrapper function \code{dlg()} for density estimation. This will
ensure that all parameters have proper values.
}
\examples{
  x <- cbind(rnorm(100), rnorm(100), rnorm(100))
  bw <- c(1, 1, 1)
  eval_points <- cbind(seq(-4, 4, 1), seq(-4, 4, 1), seq(-4, 4, 1))

  estimate <- dlg_trivariate(x, eval_points = eval_points, bw = bw)

}
