% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection.R
\name{bw_simple}
\alias{bw_simple}
\title{Create simple bandwidth object}
\usage{
bw_simple(joint = 1, marg = NA, x = NULL, dim = NULL)
}
\arguments{
\item{joint}{Joint bandwidth}

\item{marg}{Marginal bandwidths}

\item{x}{The data set}

\item{dim}{The number of variables}
}
\description{
Create a simple bandwidths object for local Gaussian correlations
}
\details{
This function provides a quick way of producing a bandwidth object that may
be used in the \code{lg_main()}-function. The user must specify a bandwidth
\code{joint} that is used for all joint bandwidths, and the user may specify
\code{marg}, a marginal bandwidth that will be used for all marginal
bandwidths. This is needed if the subsequent analyses use
\code{est_method = "5par_marginals_fixed"}.

The function must know the dimension of the problem, which is achieved by
either supplying the data set \code{x} or the number of variables \code{dim}.
}
\examples{

  bw_object <- bw_simple(joint = 1, marg = 1, dim = 3)

}
