% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_iucncont.R
\name{lets.iucncont}
\alias{lets.iucncont}
\title{Transform IUCN RedList conservation status to continuous values}
\usage{
lets.iucncont(x, dd = NA, ne = NA)
}
\arguments{
\item{x}{A vector or a matrix containing IUCN codes to be transformed.}

\item{dd}{The value to be attributed to DD (data-deficient) species, the default option is NA.}

\item{ne}{The value to be attributed to NE (not-evaluated) species, the default option is NA.}
}
\value{
Returns a vector/matrix with continuos values from 0 to 5.

EX and EW = 5

CR = 4

EN = 3

VU = 2

NT = 1

LC = 0

DD = NA

NE = NA
}
\description{
Transform IUCN RedList conservation status to continuous values ranging from 0 to 5.
}
\examples{
\dontrun{
#Vector transformation
status <- sample(c("EN","VU", "NT", "CR", "DD", "LC", "EX"), 
                 30, replace = TRUE) 
transV <- lets.iucncont(status)

#matrix transformation
data(IUCN)
transM <- lets.iucncont(IUCN)

}

}
\references{
Purvis A et al., 2000. Predicting extinction risk in
declining species. Proceedings of the Royal Society of London.
Series B: Biological Sciences, 267.1456: 1947-1952.
}
\seealso{
\code{\link{lets.iucn}}
}
\author{
Bruno Vilela
}
