% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizeSmoothSEMInterface.R
\name{ridgeBfgs}
\alias{ridgeBfgs}
\title{ridgeBfgs}
\usage{
ridgeBfgs(
  lavaanModel,
  regularized,
  lambdas = NULL,
  modifyModel = lessSEM::modifyModel(),
  control = lessSEM::controlBFGS()
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{regularized}{vector with names of parameters which are to be regularized.
If you are unsure what these parameters are called, use
getLavaanParameters(model) with your lavaan model object}

\item{lambdas}{numeric vector: values for the tuning parameter lambda}

\item{modifyModel}{used to modify the lavaanModel. See ?modifyModel.}

\item{control}{used to control the optimizer. This element is generated with
the controlBFGS function. See ?controlBFGS for more details.}
}
\value{
Model of class regularizedSEM
}
\description{
This function allows for regularization of models built in lavaan with the
ridge penalty. Its elements can be accessed
with the "@" operator (see examples).
}
\details{
For more details, see:
\enumerate{
\item Jacobucci, R., Grimm, K. J., & McArdle, J. J. (2016).
Regularized Structural Equation Modeling. Structural Equation Modeling:
A Multidisciplinary Journal, 23(4), 555–566. https://doi.org/10.1080/10705511.2016.1154793
\item Huang, P.-H., Chen, H., & Weng, L.-J. (2017). A Penalized Likelihood
Method for Structural Equation Modeling. Psychometrika, 82(2),
329–354. https://doi.org/10.1007/s11336-017-9566-9
}
}
\examples{
library(lessSEM)

# Identical to regsem, lessSEM builds on the lavaan
# package for model specification. The first step
# therefore is to implement the model in lavaan.

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 +
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 +
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)

# Regularization:

# names of the regularized parameters:
regularized = paste0("l", 6:15)

lsem <- ridgeBfgs(
  # pass the fitted lavaan model
  lavaanModel = lavaanModel,
  regularized = regularized,
  lambdas = seq(0,1,length.out = 50))

plot(lsem)

# the coefficients can be accessed with:
coef(lsem)

# elements of lsem can be accessed with the @ operator:
lsem@parameters[1,]
}
