% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lehdr.R
\name{grab_lodes}
\alias{grab_lodes}
\title{Download and load LODES data into a data frame (tibble)}
\usage{
grab_lodes(
  state,
  year,
  lodes_type = c("od", "rac", "wac"),
  job_type = c("JT00", "JT01", "JT02", "JT03", "JT04", "JT05"),
  segment = c("S000", "SA01", "SA02", "SA03", "SE01", "SE02", "SE03", "SI01", "SI02",
    "SI03"),
  agg_geo = c("block", "bg", "tract", "county", "state"),
  state_part = c("", "main", "aux"),
  download_dir = file.path(rappdirs::user_cache_dir(appname = "lehdr"))
)
}
\arguments{
\item{state}{US state abbreviation in lower case, can be a vector of states.}

\item{year}{year of the lodes data, can be a vector of years.}

\item{lodes_type}{table type, values can be origin-destination ("od"), 
residential association ("rac"), or workplace association ("wac"). od 
files give a home and destination census block for workers. Residential 
files give job totals of worker home census blocks and workplace files 
give job totals of worker job census blocks}

\item{job_type}{Jobtype: "JT00" for all jobs, "JT01" for Primary Jobs, 
"JT02" for All Private Jobs, "JT03" for Private Primary jobs, "JT04" for
All Federal jobs, "JT05" for Federal Primary jobs}

\item{segment}{Segment of the workforce: "S000" total number of jobs for
workers, "SA01" number of jobs for workers aged 29 or younger, "SA02" number
of jobs for workers aged 30-54,"SA03" number of jobs for workers 55 and
older, "SE01" number of jobs with earnings $1,250/month or less, "SE02"
number of jobs with earnings $1,251 to $3,333/month, "SE03" number of jobs
with earnings greater than $3,333/month, "SI01" number of jobs in Goods
Producing industry sectors, "SI02" number of jobs in Trade, 
Transportation, and Utilities industry sectors, "SI03" number of jobs in 
All Other Services industry sectors}

\item{agg_geo}{Aggregate to a geography other than Census Block (default). 
Values can be "bg" for block group, "tract", "county", or "state".}

\item{state_part}{Part of the state file, can have values of "main" or "aux"
in OD files. Using "main" includes workers with their workplace and
residence in the state. Using "aux" includes workers with residences out 
of state and workplace in the state of interest}

\item{download_dir}{Directory where lodes table will be downloaded.}
}
\value{
a dataframe (tibble) of block or tract level LODES files
}
\description{
Download LODES OD, RAC, and WAC tables
}
\examples{
\dontrun{
 # download and load 2014 block level O-D data for Oregon
 blk_df_or_od <- grab_lodes(state = 'or', year = 2014, lodes_type = "od", job_type = "JT01", 
                         segment = "SA01", state_part = "main")
                         
 # download and load 2014 O-D data for Oregon and aggregate 
 # to the tract level                     
 trt_df_or_od <- grab_lodes(state = 'or', year = 2014, lodes_type = "od", job_type = "JT01", 
                         segment = "SA01", state_part = "main", agg_geo = "tract")
                         
 # download and load 2014 RAC data for Oregon and aggregate 
 # to the tract level                                              
 trt_df_or_rac <- grab_lodes(state = 'or', year = 2014, lodes_type = "rac", job_type = "JT01", 
                          segment = "SA01", agg_geo = "tract")
                          
 # download and load 2014 WAC data for Oregon and aggregate 
 # to the tract level                        
 trt_df_or_wac <- grab_lodes(state = 'or', year = 2014, lodes_type = "wac", job_type = "JT01", 
                          segment = "SA01", agg_geo = "tract")
}                         
}
