% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{actualstage3}
\alias{actualstage3}
\title{Calculate Actual Stage, Age-Stage, or Stage-Pair Distributions}
\usage{
actualstage3(
  data,
  historical = FALSE,
  year2 = "year2",
  indices = c("stage3index", "stage2index", "stage1index"),
  stagecol = c("stage3", "stage2", "stage1"),
  remove.stage = "NotAlive"
)
}
\arguments{
\item{data}{A demographic dataset in hfv format.}

\item{historical}{A logical value indicating whether the stage structure
should be ahistorical (\code{FALSE}) or historical (\code{TRUE}). Defaults to
\code{FALSE}.}

\item{year2}{A string value indicating the name of the variable coding for
monitoring occasion at time \emph{t}.}

\item{indices}{A vector of three strings, indicating the stage indices for
times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively, in \code{data}.
Defaults to \code{c("stage3index", "stage2index", "stage1index")}.}

\item{stagecol}{A vector of three strings, indicating the stage name columns
for times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively, in \code{data}.
Defaults to \code{stagecol = c("stage3", "stage2", "stage1")}.}

\item{remove.stage}{A string vector indicating the names of stages to remove
from consideration. Defaults to \code{"NotAlive"}.}
}
\value{
A data frame with the following variables:
\item{rowid}{A string identifier term, equal to the monitoring occasion in
time \emph{t} and the stage index.}
\item{stageindex}{The stageframe index of the stage.}
\item{stage}{The name of each stage, or \code{NA}.}
\item{stage2}{The name of the stage in time \emph{t}.}
\item{stage1}{The name of the stage in time \emph{t}-1, or \code{NA}.}
\item{year2}{Monitoring occasion in time \emph{t}.}
\item{frequency}{The number of individuals in the respective stage and time.}
\item{actual_prop}{The proportion of individuals alive in time \emph{t} in
the respective stage.}
}
\description{
Function \code{actualstage3()} shows the frequencies and proportions of
each stage or stage pair in each year.
}
\section{Notes}{

This function produces frequencies and proportions of stages in hfv formatted
data using stage index variables rather than stage name variables, and so
requires the former. The latter is only required if the user wants to know
the associated stage names.

Frequencies and proportions will be calculated for all times, including the
last time, which is generally found in the \code{stage3} columns of the last
\code{year2} entry in object \code{data}. The default is to treat the
\code{year2} entry for that time as \code{max(year2) + 1}.

Note that no stageframe is required for this function to operate. Stage
names and their order are inferred directly from the object \code{data}.
}

\examples{
sizevector <- c(0, 0, 0, 0, 0, 0, 1, 3, 6, 11, 19.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1.5, 1.5, 3.5, 5)
comments <- c("Dormant seed", "1st yr protocorm", "2nd yr protocorm",
  "3rd yr protocorm", "Seedling", "Dormant adult",
  "Extra small adult (1 shoot)", "Small adult (2-4 shoots)",
  "Medium adult (5-7 shoots)", "Large adult (8-14 shoots)",
  "Extra large adult (>14 shoots)")
cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset, 
  binhalfwidth = binvec, comments = comments)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004, 
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

all_stage_props <- actualstage3(cypraw_v1)
all_stage_props

}
