% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{lambda3.matrix}
\alias{lambda3.matrix}
\title{Estimate Deterministic Population Growth Rate of a Projection Matrix}
\usage{
\method{lambda3}{matrix}(mats)
}
\arguments{
\item{mats}{A population projection matrix of class \code{matrix}.}
}
\value{
This function returns the dominant eigenvalue of the matrix. This
is given as the largest real part of all eigenvalues estimated via the 
\code{\link[RSpectra]{eigs}()} function in package 'RSpectra'.
}
\description{
\code{lambda3.matrix()} returns the dominant eigenvalues of a single
projection matrix. This function can handle large and sparse matrices, 
and so can be used with large historical matrices, IPMs, age x stage 
matrices, as well as smaller ahistorical matrices.
}
\examples{
\donttest{
data(lathyrus)
sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, repstatus = repvector, 
                       obsstatus = obsvector, matstatus = matvector, immstatus = immvector, 
                       indataset = indataset, binhalfwidth = binvec, propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, patchidcol = "SUBPLOT", 
                         individcol = "GENET", blocksize = 9, juvcol = "Seedling1988", 
                         size1col = "Volume88", repstr1col = "FCODE88", 
                         fec1col = "Intactseed88", dead1col = "Dead1988", 
                         nonobs1col = "Dormant1988", stageassign = lathframe, 
                         stagesize = "sizea", censorcol = "Missing1988", 
                         censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"), stage2 = c("Sd", "Sd", "Sd"), 
                       stage1 = c("Sd", "rep", "rep"), givenrate = c(0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = c(1989, 1990), 
                   stages = c("stage3", "stage2", "stage1"), repmatrix = lathrepm, 
                   overwrite = lathover3, yearcol = "year2", 
                   indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
lambda3(ehrlen3mean$A[[1]])
}

}
\seealso{
\code{\link{lambda3}()}

\code{\link{lambda3.lefkoMat}()}
}
