% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_checkbox.R
\name{question_checkbox}
\alias{question_checkbox}
\title{Checkbox question}
\usage{
question_checkbox(text, ..., correct = "Correct!",
  incorrect = "Incorrect", try_again = incorrect,
  allow_retry = FALSE, random_answer_order = FALSE)
}
\arguments{
\item{text}{Question or option text}

\item{...}{answers and extra parameters passed onto \code{\link{question}}.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{FALSE}.}

\item{try_again}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{TRUE}.}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{random_answer_order}{Display answers in a random order.}
}
\description{
Creates a checkbox group tutorial quiz question.  The student may select one or more
checkboxes before submitting their answer.
}
\examples{
question_checkbox(
  "Select all the toppings that belong on a Margherita Pizza:",
  answer("tomato", correct = TRUE),
  answer("mozzarella", correct = TRUE),
  answer("basil", correct = TRUE),
  answer("extra virgin olive oil", correct = TRUE),
  answer("pepperoni", message = "Great topping! ... just not on a Margherita Pizza"),
  answer("onions"),
  answer("bacon"),
  answer("spinach"),
  random_answer_order = TRUE,
  allow_retry = TRUE,
  try_again = "Be sure to select all four toppings!"
)
}
\seealso{
\code{\link{question_radio}}, \code{\link{question_text}}
}
