% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_api_key.R
\name{lp_api_key}
\alias{lp_api_key}
\alias{lp_have_api_key}
\title{Find API Key for Leanpub}
\usage{
lp_api_key(api_key = NULL, error = TRUE)

lp_have_api_key(api_key = NULL)
}
\arguments{
\item{api_key}{Leanpub API key (\code{Sys.getenv('LEANPUB_API_KEY')})}

\item{error}{Should the function error if \code{api_key = NULL}?}
}
\value{
Character API key
}
\description{
Determines if Leanpub API Key is set.
If not, it stops and returns an error.  If so, returns the value.
}
\note{
You can either set the API key or have it accessible by
\code{api_key = Sys.getenv('LEANPUB_API_KEY')}.
}
\examples{
res = lp_api_key(error = FALSE)
lp_have_api_key()
}
