providers_version_num <- "1.13.0"
providers_data <- list(OpenStreetMap = "OpenStreetMap", OpenStreetMap.Mapnik = "OpenStreetMap.Mapnik", 
    OpenStreetMap.DE = "OpenStreetMap.DE", OpenStreetMap.CH = "OpenStreetMap.CH", 
    OpenStreetMap.France = "OpenStreetMap.France", OpenStreetMap.HOT = "OpenStreetMap.HOT", 
    OpenStreetMap.BZH = "OpenStreetMap.BZH", OpenSeaMap = "OpenSeaMap", 
    OPNVKarte = "OPNVKarte", OpenTopoMap = "OpenTopoMap", OpenRailwayMap = "OpenRailwayMap", 
    OpenFireMap = "OpenFireMap", SafeCast = "SafeCast", Stadia = "Stadia", 
    Stadia.AlidadeSmooth = "Stadia.AlidadeSmooth", Stadia.AlidadeSmoothDark = "Stadia.AlidadeSmoothDark", 
    Stadia.OSMBright = "Stadia.OSMBright", Stadia.Outdoors = "Stadia.Outdoors", 
    Thunderforest = "Thunderforest", Thunderforest.OpenCycleMap = "Thunderforest.OpenCycleMap", 
    Thunderforest.Transport = "Thunderforest.Transport", Thunderforest.TransportDark = "Thunderforest.TransportDark", 
    Thunderforest.SpinalMap = "Thunderforest.SpinalMap", Thunderforest.Landscape = "Thunderforest.Landscape", 
    Thunderforest.Outdoors = "Thunderforest.Outdoors", Thunderforest.Pioneer = "Thunderforest.Pioneer", 
    Thunderforest.MobileAtlas = "Thunderforest.MobileAtlas", 
    Thunderforest.Neighbourhood = "Thunderforest.Neighbourhood", 
    CyclOSM = "CyclOSM", Hydda = "Hydda", Hydda.Full = "Hydda.Full", 
    Hydda.Base = "Hydda.Base", Hydda.RoadsAndLabels = "Hydda.RoadsAndLabels", 
    Jawg = "Jawg", Jawg.Streets = "Jawg.Streets", Jawg.Terrain = "Jawg.Terrain", 
    Jawg.Sunny = "Jawg.Sunny", Jawg.Dark = "Jawg.Dark", Jawg.Light = "Jawg.Light", 
    Jawg.Matrix = "Jawg.Matrix", MapBox = "MapBox", MapTiler = "MapTiler", 
    MapTiler.Streets = "MapTiler.Streets", MapTiler.Basic = "MapTiler.Basic", 
    MapTiler.Bright = "MapTiler.Bright", MapTiler.Pastel = "MapTiler.Pastel", 
    MapTiler.Positron = "MapTiler.Positron", MapTiler.Hybrid = "MapTiler.Hybrid", 
    MapTiler.Toner = "MapTiler.Toner", MapTiler.Topo = "MapTiler.Topo", 
    MapTiler.Voyager = "MapTiler.Voyager", Stamen = "Stamen", 
    Stamen.Toner = "Stamen.Toner", Stamen.TonerBackground = "Stamen.TonerBackground", 
    Stamen.TonerHybrid = "Stamen.TonerHybrid", Stamen.TonerLines = "Stamen.TonerLines", 
    Stamen.TonerLabels = "Stamen.TonerLabels", Stamen.TonerLite = "Stamen.TonerLite", 
    Stamen.Watercolor = "Stamen.Watercolor", Stamen.Terrain = "Stamen.Terrain", 
    Stamen.TerrainBackground = "Stamen.TerrainBackground", Stamen.TerrainLabels = "Stamen.TerrainLabels", 
    Stamen.TopOSMRelief = "Stamen.TopOSMRelief", Stamen.TopOSMFeatures = "Stamen.TopOSMFeatures", 
    TomTom = "TomTom", TomTom.Basic = "TomTom.Basic", TomTom.Hybrid = "TomTom.Hybrid", 
    TomTom.Labels = "TomTom.Labels", Esri = "Esri", Esri.WorldStreetMap = "Esri.WorldStreetMap", 
    Esri.DeLorme = "Esri.DeLorme", Esri.WorldTopoMap = "Esri.WorldTopoMap", 
    Esri.WorldImagery = "Esri.WorldImagery", Esri.WorldTerrain = "Esri.WorldTerrain", 
    Esri.WorldShadedRelief = "Esri.WorldShadedRelief", Esri.WorldPhysical = "Esri.WorldPhysical", 
    Esri.OceanBasemap = "Esri.OceanBasemap", Esri.NatGeoWorldMap = "Esri.NatGeoWorldMap", 
    Esri.WorldGrayCanvas = "Esri.WorldGrayCanvas", OpenWeatherMap = "OpenWeatherMap", 
    OpenWeatherMap.Clouds = "OpenWeatherMap.Clouds", OpenWeatherMap.CloudsClassic = "OpenWeatherMap.CloudsClassic", 
    OpenWeatherMap.Precipitation = "OpenWeatherMap.Precipitation", 
    OpenWeatherMap.PrecipitationClassic = "OpenWeatherMap.PrecipitationClassic", 
    OpenWeatherMap.Rain = "OpenWeatherMap.Rain", OpenWeatherMap.RainClassic = "OpenWeatherMap.RainClassic", 
    OpenWeatherMap.Pressure = "OpenWeatherMap.Pressure", OpenWeatherMap.PressureContour = "OpenWeatherMap.PressureContour", 
    OpenWeatherMap.Wind = "OpenWeatherMap.Wind", OpenWeatherMap.Temperature = "OpenWeatherMap.Temperature", 
    OpenWeatherMap.Snow = "OpenWeatherMap.Snow", HERE = "HERE", 
    HERE.normalDay = "HERE.normalDay", HERE.normalDayCustom = "HERE.normalDayCustom", 
    HERE.normalDayGrey = "HERE.normalDayGrey", HERE.normalDayMobile = "HERE.normalDayMobile", 
    HERE.normalDayGreyMobile = "HERE.normalDayGreyMobile", HERE.normalDayTransit = "HERE.normalDayTransit", 
    HERE.normalDayTransitMobile = "HERE.normalDayTransitMobile", 
    HERE.normalDayTraffic = "HERE.normalDayTraffic", HERE.normalNight = "HERE.normalNight", 
    HERE.normalNightMobile = "HERE.normalNightMobile", HERE.normalNightGrey = "HERE.normalNightGrey", 
    HERE.normalNightGreyMobile = "HERE.normalNightGreyMobile", 
    HERE.normalNightTransit = "HERE.normalNightTransit", HERE.normalNightTransitMobile = "HERE.normalNightTransitMobile", 
    HERE.reducedDay = "HERE.reducedDay", HERE.reducedNight = "HERE.reducedNight", 
    HERE.basicMap = "HERE.basicMap", HERE.mapLabels = "HERE.mapLabels", 
    HERE.trafficFlow = "HERE.trafficFlow", HERE.carnavDayGrey = "HERE.carnavDayGrey", 
    HERE.hybridDay = "HERE.hybridDay", HERE.hybridDayMobile = "HERE.hybridDayMobile", 
    HERE.hybridDayTransit = "HERE.hybridDayTransit", HERE.hybridDayGrey = "HERE.hybridDayGrey", 
    HERE.hybridDayTraffic = "HERE.hybridDayTraffic", HERE.pedestrianDay = "HERE.pedestrianDay", 
    HERE.pedestrianNight = "HERE.pedestrianNight", HERE.satelliteDay = "HERE.satelliteDay", 
    HERE.terrainDay = "HERE.terrainDay", HERE.terrainDayMobile = "HERE.terrainDayMobile", 
    HEREv3 = "HEREv3", HEREv3.normalDay = "HEREv3.normalDay", 
    HEREv3.normalDayCustom = "HEREv3.normalDayCustom", HEREv3.normalDayGrey = "HEREv3.normalDayGrey", 
    HEREv3.normalDayMobile = "HEREv3.normalDayMobile", HEREv3.normalDayGreyMobile = "HEREv3.normalDayGreyMobile", 
    HEREv3.normalDayTransit = "HEREv3.normalDayTransit", HEREv3.normalDayTransitMobile = "HEREv3.normalDayTransitMobile", 
    HEREv3.normalNight = "HEREv3.normalNight", HEREv3.normalNightMobile = "HEREv3.normalNightMobile", 
    HEREv3.normalNightGrey = "HEREv3.normalNightGrey", HEREv3.normalNightGreyMobile = "HEREv3.normalNightGreyMobile", 
    HEREv3.normalNightTransit = "HEREv3.normalNightTransit", 
    HEREv3.normalNightTransitMobile = "HEREv3.normalNightTransitMobile", 
    HEREv3.reducedDay = "HEREv3.reducedDay", HEREv3.reducedNight = "HEREv3.reducedNight", 
    HEREv3.basicMap = "HEREv3.basicMap", HEREv3.mapLabels = "HEREv3.mapLabels", 
    HEREv3.trafficFlow = "HEREv3.trafficFlow", HEREv3.carnavDayGrey = "HEREv3.carnavDayGrey", 
    HEREv3.hybridDay = "HEREv3.hybridDay", HEREv3.hybridDayMobile = "HEREv3.hybridDayMobile", 
    HEREv3.hybridDayTransit = "HEREv3.hybridDayTransit", HEREv3.hybridDayGrey = "HEREv3.hybridDayGrey", 
    HEREv3.pedestrianDay = "HEREv3.pedestrianDay", HEREv3.pedestrianNight = "HEREv3.pedestrianNight", 
    HEREv3.satelliteDay = "HEREv3.satelliteDay", HEREv3.terrainDay = "HEREv3.terrainDay", 
    HEREv3.terrainDayMobile = "HEREv3.terrainDayMobile", FreeMapSK = "FreeMapSK", 
    MtbMap = "MtbMap", CartoDB = "CartoDB", CartoDB.Positron = "CartoDB.Positron", 
    CartoDB.PositronNoLabels = "CartoDB.PositronNoLabels", CartoDB.PositronOnlyLabels = "CartoDB.PositronOnlyLabels", 
    CartoDB.DarkMatter = "CartoDB.DarkMatter", CartoDB.DarkMatterNoLabels = "CartoDB.DarkMatterNoLabels", 
    CartoDB.DarkMatterOnlyLabels = "CartoDB.DarkMatterOnlyLabels", 
    CartoDB.Voyager = "CartoDB.Voyager", CartoDB.VoyagerNoLabels = "CartoDB.VoyagerNoLabels", 
    CartoDB.VoyagerOnlyLabels = "CartoDB.VoyagerOnlyLabels", 
    CartoDB.VoyagerLabelsUnder = "CartoDB.VoyagerLabelsUnder", 
    HikeBike = "HikeBike", HikeBike.HikeBike = "HikeBike.HikeBike", 
    HikeBike.HillShading = "HikeBike.HillShading", BasemapAT = "BasemapAT", 
    BasemapAT.basemap = "BasemapAT.basemap", BasemapAT.grau = "BasemapAT.grau", 
    BasemapAT.overlay = "BasemapAT.overlay", BasemapAT.terrain = "BasemapAT.terrain", 
    BasemapAT.surface = "BasemapAT.surface", BasemapAT.highdpi = "BasemapAT.highdpi", 
    BasemapAT.orthofoto = "BasemapAT.orthofoto", nlmaps = "nlmaps", 
    nlmaps.standaard = "nlmaps.standaard", nlmaps.pastel = "nlmaps.pastel", 
    nlmaps.grijs = "nlmaps.grijs", nlmaps.luchtfoto = "nlmaps.luchtfoto", 
    NASAGIBS = "NASAGIBS", NASAGIBS.ModisTerraTrueColorCR = "NASAGIBS.ModisTerraTrueColorCR", 
    NASAGIBS.ModisTerraBands367CR = "NASAGIBS.ModisTerraBands367CR", 
    NASAGIBS.ViirsEarthAtNight2012 = "NASAGIBS.ViirsEarthAtNight2012", 
    NASAGIBS.ModisTerraLSTDay = "NASAGIBS.ModisTerraLSTDay", 
    NASAGIBS.ModisTerraSnowCover = "NASAGIBS.ModisTerraSnowCover", 
    NASAGIBS.ModisTerraAOD = "NASAGIBS.ModisTerraAOD", NASAGIBS.ModisTerraChlorophyll = "NASAGIBS.ModisTerraChlorophyll", 
    NLS = "NLS", JusticeMap = "JusticeMap", JusticeMap.income = "JusticeMap.income", 
    JusticeMap.americanIndian = "JusticeMap.americanIndian", 
    JusticeMap.asian = "JusticeMap.asian", JusticeMap.black = "JusticeMap.black", 
    JusticeMap.hispanic = "JusticeMap.hispanic", JusticeMap.multi = "JusticeMap.multi", 
    JusticeMap.nonWhite = "JusticeMap.nonWhite", JusticeMap.white = "JusticeMap.white", 
    JusticeMap.plurality = "JusticeMap.plurality", GeoportailFrance = "GeoportailFrance", 
    GeoportailFrance.plan = "GeoportailFrance.plan", GeoportailFrance.parcels = "GeoportailFrance.parcels", 
    GeoportailFrance.orthos = "GeoportailFrance.orthos", OneMapSG = "OneMapSG", 
    OneMapSG.Default = "OneMapSG.Default", OneMapSG.Night = "OneMapSG.Night", 
    OneMapSG.Original = "OneMapSG.Original", OneMapSG.Grey = "OneMapSG.Grey", 
    OneMapSG.LandLot = "OneMapSG.LandLot", USGS = "USGS", USGS.USTopo = "USGS.USTopo", 
    USGS.USImagery = "USGS.USImagery", USGS.USImageryTopo = "USGS.USImageryTopo", 
    WaymarkedTrails = "WaymarkedTrails", WaymarkedTrails.hiking = "WaymarkedTrails.hiking", 
    WaymarkedTrails.cycling = "WaymarkedTrails.cycling", WaymarkedTrails.mtb = "WaymarkedTrails.mtb", 
    WaymarkedTrails.slopes = "WaymarkedTrails.slopes", WaymarkedTrails.riding = "WaymarkedTrails.riding", 
    WaymarkedTrails.skating = "WaymarkedTrails.skating", OpenAIP = "OpenAIP", 
    OpenSnowMap = "OpenSnowMap", OpenSnowMap.pistes = "OpenSnowMap.pistes", 
    AzureMaps = "AzureMaps", AzureMaps.MicrosoftImagery = "AzureMaps.MicrosoftImagery", 
    AzureMaps.MicrosoftBaseDarkGrey = "AzureMaps.MicrosoftBaseDarkGrey", 
    AzureMaps.MicrosoftBaseRoad = "AzureMaps.MicrosoftBaseRoad", 
    AzureMaps.MicrosoftBaseHybridRoad = "AzureMaps.MicrosoftBaseHybridRoad", 
    AzureMaps.MicrosoftTerraMain = "AzureMaps.MicrosoftTerraMain", 
    AzureMaps.MicrosoftWeatherInfraredMain = "AzureMaps.MicrosoftWeatherInfraredMain", 
    AzureMaps.MicrosoftWeatherRadarMain = "AzureMaps.MicrosoftWeatherRadarMain")

providers_details_data <- list(OpenStreetMap = list(url = "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", 
    options = list(maxZoom = 19L, attribution = "&copy; <a href=\"https://www.openstreetmap.org/copyright\">OpenStreetMap</a> contributors"), 
    variants = list(Mapnik = structure(list(), names = character(0)), 
        DE = list(url = "https://{s}.tile.openstreetmap.de/tiles/osmde/{z}/{x}/{y}.png", 
            options = list(maxZoom = 18L)), CH = list(url = "https://tile.osm.ch/switzerland/{z}/{x}/{y}.png", 
            options = list(maxZoom = 18L, bounds = structure(c(45L, 
            48L, 5L, 11L), dim = c(2L, 2L)))), France = list(
            url = "https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png", 
            options = list(maxZoom = 20L, attribution = "&copy; OpenStreetMap France | {attribution.OpenStreetMap}")), 
        HOT = list(url = "https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png", 
            options = list(attribution = "{attribution.OpenStreetMap}, Tiles style by <a href=\"https://www.hotosm.org/\" target=\"_blank\">Humanitarian OpenStreetMap Team</a> hosted by <a href=\"https://openstreetmap.fr/\" target=\"_blank\">OpenStreetMap France</a>")), 
        BZH = list(url = "https://tile.openstreetmap.bzh/br/{z}/{x}/{y}.png", 
            options = list(attribution = "{attribution.OpenStreetMap}, Tiles courtesy of <a href=\"http://www.openstreetmap.bzh/\" target=\"_blank\">Breton OpenStreetMap Team</a>", 
                bounds = structure(c(46.2, 50, -5.5, 0.7), dim = c(2L, 
                2L)))))), OpenSeaMap = list(url = "https://tiles.openseamap.org/seamark/{z}/{x}/{y}.png", 
    options = list(attribution = "Map data: &copy; <a href=\"http://www.openseamap.org\">OpenSeaMap</a> contributors")), 
    OPNVKarte = list(url = "https://tileserver.memomaps.de/tilegen/{z}/{x}/{y}.png", 
        options = list(maxZoom = 18L, attribution = "Map <a href=\"https://memomaps.de/\">memomaps.de</a> <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, map data {attribution.OpenStreetMap}")), 
    OpenTopoMap = list(url = "https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png", 
        options = list(maxZoom = 17L, attribution = "Map data: {attribution.OpenStreetMap}, <a href=\"http://viewfinderpanoramas.org\">SRTM</a> | Map style: &copy; <a href=\"https://opentopomap.org\">OpenTopoMap</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-SA</a>)")), 
    OpenRailwayMap = list(url = "https://{s}.tiles.openrailwaymap.org/standard/{z}/{x}/{y}.png", 
        options = list(maxZoom = 19L, attribution = "Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href=\"https://www.OpenRailwayMap.org\">OpenRailwayMap</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-SA</a>)")), 
    OpenFireMap = list(url = "http://openfiremap.org/hytiles/{z}/{x}/{y}.png", 
        options = list(maxZoom = 19L, attribution = "Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href=\"http://www.openfiremap.org\">OpenFireMap</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-SA</a>)")), 
    SafeCast = list(url = "https://s3.amazonaws.com/te512.safecast.org/{z}/{x}/{y}.png", 
        options = list(maxZoom = 16L, attribution = "Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href=\"https://blog.safecast.org/about/\">SafeCast</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-SA</a>)")), 
    Stadia = list(url = "https://tiles.stadiamaps.com/tiles/alidade_smooth/{z}/{x}/{y}{r}.png", 
        options = list(maxZoom = 20L, attribution = "&copy; <a href=\"https://stadiamaps.com/\">Stadia Maps</a>, &copy; <a href=\"https://openmaptiles.org/\">OpenMapTiles</a> &copy; <a href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors"), 
        variants = list(AlidadeSmooth = list(url = "https://tiles.stadiamaps.com/tiles/alidade_smooth/{z}/{x}/{y}{r}.png"), 
            AlidadeSmoothDark = list(url = "https://tiles.stadiamaps.com/tiles/alidade_smooth_dark/{z}/{x}/{y}{r}.png"), 
            OSMBright = list(url = "https://tiles.stadiamaps.com/tiles/osm_bright/{z}/{x}/{y}{r}.png"), 
            Outdoors = list(url = "https://tiles.stadiamaps.com/tiles/outdoors/{z}/{x}/{y}{r}.png"))), 
    Thunderforest = list(url = "https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}", 
        options = list(attribution = "&copy; <a href=\"http://www.thunderforest.com/\">Thunderforest</a>, {attribution.OpenStreetMap}", 
            variant = "cycle", apikey = "<insert your api key here>", 
            maxZoom = 22L), variants = list(OpenCycleMap = "cycle", 
            Transport = list(options = list(variant = "transport")), 
            TransportDark = list(options = list(variant = "transport-dark")), 
            SpinalMap = list(options = list(variant = "spinal-map")), 
            Landscape = "landscape", Outdoors = "outdoors", Pioneer = "pioneer", 
            MobileAtlas = "mobile-atlas", Neighbourhood = "neighbourhood")), 
    CyclOSM = list(url = "https://{s}.tile-cyclosm.openstreetmap.fr/cyclosm/{z}/{x}/{y}.png", 
        options = list(maxZoom = 20L, attribution = "<a href=\"https://github.com/cyclosm/cyclosm-cartocss-style/releases\" title=\"CyclOSM - Open Bicycle render\">CyclOSM</a> | Map data: {attribution.OpenStreetMap}")), 
    Hydda = list(url = "https://{s}.tile.openstreetmap.se/hydda/{variant}/{z}/{x}/{y}.png", 
        options = list(maxZoom = 20L, variant = "full", attribution = "Tiles courtesy of <a href=\"http://openstreetmap.se/\" target=\"_blank\">OpenStreetMap Sweden</a> &mdash; Map data {attribution.OpenStreetMap}"), 
        variants = list(Full = "full", Base = "base", RoadsAndLabels = "roads_and_labels")), 
    Jawg = list(url = "https://{s}.tile.jawg.io/{variant}/{z}/{x}/{y}{r}.png?access-token={accessToken}", 
        options = list(attribution = "<a href=\"http://jawg.io\" title=\"Tiles Courtesy of Jawg Maps\" target=\"_blank\">&copy; <b>Jawg</b>Maps</a> {attribution.OpenStreetMap}", 
            minZoom = 0L, maxZoom = 22L, subdomains = "abcd", 
            variant = "jawg-terrain", accessToken = "<insert your access token here>"), 
        variants = list(Streets = "jawg-streets", Terrain = "jawg-terrain", 
            Sunny = "jawg-sunny", Dark = "jawg-dark", Light = "jawg-light", 
            Matrix = "jawg-matrix")), MapBox = list(url = "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}{r}?access_token={accessToken}", 
        options = list(attribution = "&copy; <a href=\"https://www.mapbox.com/about/maps/\" target=\"_blank\">Mapbox</a> {attribution.OpenStreetMap} <a href=\"https://www.mapbox.com/map-feedback/\" target=\"_blank\">Improve this map</a>", 
            tileSize = 512L, maxZoom = 18L, zoomOffset = -1L, 
            id = "mapbox/streets-v11", accessToken = "<insert your access token here>")), 
    MapTiler = list(url = "https://api.maptiler.com/maps/{variant}/{z}/{x}/{y}{r}.{ext}?key={key}", 
        options = list(attribution = "<a href=\"https://www.maptiler.com/copyright/\" target=\"_blank\">&copy; MapTiler</a> <a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">&copy; OpenStreetMap contributors</a>", 
            variant = "streets", ext = "png", key = "<insert your MapTiler Cloud API key here>", 
            tileSize = 512L, zoomOffset = -1L, minZoom = 0L, 
            maxZoom = 21L), variants = list(Streets = "streets", 
            Basic = "basic", Bright = "bright", Pastel = "pastel", 
            Positron = "positron", Hybrid = list(options = list(
                variant = "hybrid", ext = "jpg")), Toner = "toner", 
            Topo = "topo", Voyager = "voyager")), Stamen = list(
        url = "https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}", 
        options = list(attribution = "Map tiles by <a href=\"http://stamen.com\">Stamen Design</a>, <a href=\"http://creativecommons.org/licenses/by/3.0\">CC BY 3.0</a> &mdash; Map data {attribution.OpenStreetMap}", 
            subdomains = "abcd", minZoom = 0L, maxZoom = 20L, 
            variant = "toner", ext = "png"), variants = list(
            Toner = "toner", TonerBackground = "toner-background", 
            TonerHybrid = "toner-hybrid", TonerLines = "toner-lines", 
            TonerLabels = "toner-labels", TonerLite = "toner-lite", 
            Watercolor = list(url = "https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}.{ext}", 
                options = list(variant = "watercolor", ext = "jpg", 
                  minZoom = 1L, maxZoom = 16L)), Terrain = list(
                options = list(variant = "terrain", minZoom = 0L, 
                  maxZoom = 18L)), TerrainBackground = list(options = list(
                variant = "terrain-background", minZoom = 0L, 
                maxZoom = 18L)), TerrainLabels = list(options = list(
                variant = "terrain-labels", minZoom = 0L, maxZoom = 18L)), 
            TopOSMRelief = list(url = "https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}.{ext}", 
                options = list(variant = "toposm-color-relief", 
                  ext = "jpg", bounds = structure(c(22L, 51L, 
                  -132L, -56L), dim = c(2L, 2L)))), TopOSMFeatures = list(
                options = list(variant = "toposm-features", bounds = structure(c(22L, 
                51L, -132L, -56L), dim = c(2L, 2L)), opacity = 0.9)))), 
    TomTom = list(url = "https://{s}.api.tomtom.com/map/1/tile/{variant}/{style}/{z}/{x}/{y}.{ext}?key={apikey}", 
        options = list(variant = "basic", maxZoom = 22L, attribution = "<a href=\"https://tomtom.com\" target=\"_blank\">&copy;  1992 - 2023 TomTom.</a> ", 
            subdomains = "abcd", style = "main", ext = "png", 
            apikey = "<insert your API key here>"), variants = list(
            Basic = "basic", Hybrid = "hybrid", Labels = "labels")), 
    Esri = list(url = "https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}", 
        options = list(variant = "World_Street_Map", attribution = "Tiles &copy; Esri"), 
        variants = list(WorldStreetMap = list(options = list(
            attribution = "{attribution.Esri} &mdash; Source: Esri, DeLorme, NAVTEQ, USGS, Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012")), 
            DeLorme = list(options = list(variant = "Specialty/DeLorme_World_Base_Map", 
                minZoom = 1L, maxZoom = 11L, attribution = "{attribution.Esri} &mdash; Copyright: &copy;2012 DeLorme")), 
            WorldTopoMap = list(options = list(variant = "World_Topo_Map", 
                attribution = "{attribution.Esri} &mdash; Esri, DeLorme, NAVTEQ, TomTom, Intermap, iPC, USGS, FAO, NPS, NRCAN, GeoBase, Kadaster NL, Ordnance Survey, Esri Japan, METI, Esri China (Hong Kong), and the GIS User Community")), 
            WorldImagery = list(options = list(variant = "World_Imagery", 
                attribution = "{attribution.Esri} &mdash; Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community")), 
            WorldTerrain = list(options = list(variant = "World_Terrain_Base", 
                maxZoom = 13L, attribution = "{attribution.Esri} &mdash; Source: USGS, Esri, TANA, DeLorme, and NPS")), 
            WorldShadedRelief = list(options = list(variant = "World_Shaded_Relief", 
                maxZoom = 13L, attribution = "{attribution.Esri} &mdash; Source: Esri")), 
            WorldPhysical = list(options = list(variant = "World_Physical_Map", 
                maxZoom = 8L, attribution = "{attribution.Esri} &mdash; Source: US National Park Service")), 
            OceanBasemap = list(options = list(variant = "Ocean_Basemap", 
                maxZoom = 13L, attribution = "{attribution.Esri} &mdash; Sources: GEBCO, NOAA, CHS, OSU, UNH, CSUMB, National Geographic, DeLorme, NAVTEQ, and Esri")), 
            NatGeoWorldMap = list(options = list(variant = "NatGeo_World_Map", 
                maxZoom = 16L, attribution = "{attribution.Esri} &mdash; National Geographic, Esri, DeLorme, NAVTEQ, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, iPC")), 
            WorldGrayCanvas = list(options = list(variant = "Canvas/World_Light_Gray_Base", 
                maxZoom = 16L, attribution = "{attribution.Esri} &mdash; Esri, DeLorme, NAVTEQ")))), 
    OpenWeatherMap = list(url = "http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}", 
        options = list(maxZoom = 19L, attribution = "Map data &copy; <a href=\"http://openweathermap.org\">OpenWeatherMap</a>", 
            apiKey = "<insert your api key here>", opacity = 0.5), 
        variants = list(Clouds = "clouds", CloudsClassic = "clouds_cls", 
            Precipitation = "precipitation", PrecipitationClassic = "precipitation_cls", 
            Rain = "rain", RainClassic = "rain_cls", Pressure = "pressure", 
            PressureContour = "pressure_cntr", Wind = "wind", 
            Temperature = "temp", Snow = "snow")), HERE = list(
        url = "https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}", 
        options = list(attribution = "Map &copy; 1987-2023 <a href=\"http://developer.here.com\">HERE</a>", 
            subdomains = "1234", mapID = "newest", app_id = "<insert your app_id here>", 
            app_code = "<insert your app_code here>", base = "base", 
            variant = "normal.day", maxZoom = 20L, type = "maptile", 
            language = "eng", format = "png8", size = "256"), 
        variants = list(normalDay = "normal.day", normalDayCustom = "normal.day.custom", 
            normalDayGrey = "normal.day.grey", normalDayMobile = "normal.day.mobile", 
            normalDayGreyMobile = "normal.day.grey.mobile", normalDayTransit = "normal.day.transit", 
            normalDayTransitMobile = "normal.day.transit.mobile", 
            normalDayTraffic = list(options = list(variant = "normal.traffic.day", 
                base = "traffic", type = "traffictile")), normalNight = "normal.night", 
            normalNightMobile = "normal.night.mobile", normalNightGrey = "normal.night.grey", 
            normalNightGreyMobile = "normal.night.grey.mobile", 
            normalNightTransit = "normal.night.transit", normalNightTransitMobile = "normal.night.transit.mobile", 
            reducedDay = "reduced.day", reducedNight = "reduced.night", 
            basicMap = list(options = list(type = "basetile")), 
            mapLabels = list(options = list(type = "labeltile", 
                format = "png")), trafficFlow = list(options = list(
                base = "traffic", type = "flowtile")), carnavDayGrey = "carnav.day.grey", 
            hybridDay = list(options = list(base = "aerial", 
                variant = "hybrid.day")), hybridDayMobile = list(
                options = list(base = "aerial", variant = "hybrid.day.mobile")), 
            hybridDayTransit = list(options = list(base = "aerial", 
                variant = "hybrid.day.transit")), hybridDayGrey = list(
                options = list(base = "aerial", variant = "hybrid.grey.day")), 
            hybridDayTraffic = list(options = list(variant = "hybrid.traffic.day", 
                base = "traffic", type = "traffictile")), pedestrianDay = "pedestrian.day", 
            pedestrianNight = "pedestrian.night", satelliteDay = list(
                options = list(base = "aerial", variant = "satellite.day")), 
            terrainDay = list(options = list(base = "aerial", 
                variant = "terrain.day")), terrainDayMobile = list(
                options = list(base = "aerial", variant = "terrain.day.mobile")))), 
    HEREv3 = list(url = "https://{s}.{base}.maps.ls.hereapi.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?apiKey={apiKey}&lg={language}", 
        options = list(attribution = "Map &copy; 1987-2023 <a href=\"http://developer.here.com\">HERE</a>", 
            subdomains = "1234", mapID = "newest", apiKey = "<insert your apiKey here>", 
            base = "base", variant = "normal.day", maxZoom = 20L, 
            type = "maptile", language = "eng", format = "png8", 
            size = "256"), variants = list(normalDay = "normal.day", 
            normalDayCustom = "normal.day.custom", normalDayGrey = "normal.day.grey", 
            normalDayMobile = "normal.day.mobile", normalDayGreyMobile = "normal.day.grey.mobile", 
            normalDayTransit = "normal.day.transit", normalDayTransitMobile = "normal.day.transit.mobile", 
            normalNight = "normal.night", normalNightMobile = "normal.night.mobile", 
            normalNightGrey = "normal.night.grey", normalNightGreyMobile = "normal.night.grey.mobile", 
            normalNightTransit = "normal.night.transit", normalNightTransitMobile = "normal.night.transit.mobile", 
            reducedDay = "reduced.day", reducedNight = "reduced.night", 
            basicMap = list(options = list(type = "basetile")), 
            mapLabels = list(options = list(type = "labeltile", 
                format = "png")), trafficFlow = list(options = list(
                base = "traffic", type = "flowtile")), carnavDayGrey = "carnav.day.grey", 
            hybridDay = list(options = list(base = "aerial", 
                variant = "hybrid.day")), hybridDayMobile = list(
                options = list(base = "aerial", variant = "hybrid.day.mobile")), 
            hybridDayTransit = list(options = list(base = "aerial", 
                variant = "hybrid.day.transit")), hybridDayGrey = list(
                options = list(base = "aerial", variant = "hybrid.grey.day")), 
            pedestrianDay = "pedestrian.day", pedestrianNight = "pedestrian.night", 
            satelliteDay = list(options = list(base = "aerial", 
                variant = "satellite.day")), terrainDay = list(
                options = list(base = "aerial", variant = "terrain.day")), 
            terrainDayMobile = list(options = list(base = "aerial", 
                variant = "terrain.day.mobile")))), FreeMapSK = list(
        url = "https://{s}.freemap.sk/T/{z}/{x}/{y}.jpeg", options = list(
            minZoom = 8L, maxZoom = 16L, subdomains = "abcd", 
            bounds = structure(c(47.204642, 49.830896, 15.996093, 
            22.576904), dim = c(2L, 2L)), attribution = "{attribution.OpenStreetMap}, vizualization CC-By-SA 2.0 <a href=\"http://freemap.sk\">Freemap.sk</a>")), 
    MtbMap = list(url = "http://tile.mtbmap.cz/mtbmap_tiles/{z}/{x}/{y}.png", 
        options = list(attribution = "{attribution.OpenStreetMap} &amp; USGS")), 
    CartoDB = list(url = "https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png", 
        options = list(attribution = "{attribution.OpenStreetMap} &copy; <a href=\"https://carto.com/attributions\">CARTO</a>", 
            subdomains = "abcd", maxZoom = 20L, variant = "light_all"), 
        variants = list(Positron = "light_all", PositronNoLabels = "light_nolabels", 
            PositronOnlyLabels = "light_only_labels", DarkMatter = "dark_all", 
            DarkMatterNoLabels = "dark_nolabels", DarkMatterOnlyLabels = "dark_only_labels", 
            Voyager = "rastertiles/voyager", VoyagerNoLabels = "rastertiles/voyager_nolabels", 
            VoyagerOnlyLabels = "rastertiles/voyager_only_labels", 
            VoyagerLabelsUnder = "rastertiles/voyager_labels_under")), 
    HikeBike = list(url = "https://tiles.wmflabs.org/{variant}/{z}/{x}/{y}.png", 
        options = list(maxZoom = 19L, attribution = "{attribution.OpenStreetMap}", 
            variant = "hikebike"), variants = list(HikeBike = structure(list(), names = character(0)), 
            HillShading = list(options = list(maxZoom = 15L, 
                variant = "hillshading")))), BasemapAT = list(
        url = "https://maps{s}.wien.gv.at/basemap/{variant}/{type}/google3857/{z}/{y}/{x}.{format}", 
        options = list(maxZoom = 19L, attribution = "Datenquelle: <a href=\"https://www.basemap.at\">basemap.at</a>", 
            subdomains = c("", "1", "2", "3", "4"), type = "normal", 
            format = "png", bounds = structure(c(46.35877, 49.037872, 
            8.782379, 17.189532), dim = c(2L, 2L)), variant = "geolandbasemap"), 
        variants = list(basemap = list(options = list(maxZoom = 20L, 
            variant = "geolandbasemap")), grau = "bmapgrau", 
            overlay = "bmapoverlay", terrain = list(options = list(
                variant = "bmapgelaende", type = "grau", format = "jpeg")), 
            surface = list(options = list(variant = "bmapoberflaeche", 
                type = "grau", format = "jpeg")), highdpi = list(
                options = list(variant = "bmaphidpi", format = "jpeg")), 
            orthofoto = list(options = list(maxZoom = 20L, variant = "bmaporthofoto30cm", 
                format = "jpeg")))), nlmaps = list(url = "https://geodata.nationaalgeoregister.nl/tiles/service/wmts/{variant}/EPSG:3857/{z}/{x}/{y}.png", 
        options = list(minZoom = 6L, maxZoom = 19L, bounds = structure(c(50.5, 
        54, 3.25, 7.6), dim = c(2L, 2L)), attribution = "Kaartgegevens &copy; <a href=\"https://www.kadaster.nl\">Kadaster</a>"), 
        variants = list(standaard = "brtachtergrondkaart", pastel = "brtachtergrondkaartpastel", 
            grijs = "brtachtergrondkaartgrijs", luchtfoto = list(
                url = "https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0/Actueel_ortho25/EPSG:3857/{z}/{x}/{y}.jpeg"))), 
    NASAGIBS = list(url = "https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{maxZoom}/{z}/{y}/{x}.{format}", 
        options = list(attribution = "Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (<a href=\"https://earthdata.nasa.gov\">ESDIS</a>) with funding provided by NASA/HQ.", 
            bounds = structure(c(-85.0511287776, 85.0511287776, 
            -179.999999975, 179.999999975), dim = c(2L, 2L)), 
            minZoom = 1L, maxZoom = 9L, format = "jpg", time = "", 
            tilematrixset = "GoogleMapsCompatible_Level"), variants = list(
            ModisTerraTrueColorCR = "MODIS_Terra_CorrectedReflectance_TrueColor", 
            ModisTerraBands367CR = "MODIS_Terra_CorrectedReflectance_Bands367", 
            ViirsEarthAtNight2012 = list(options = list(variant = "VIIRS_CityLights_2012", 
                maxZoom = 8L)), ModisTerraLSTDay = list(options = list(
                variant = "MODIS_Terra_Land_Surface_Temp_Day", 
                format = "png", maxZoom = 7L, opacity = 0.75)), 
            ModisTerraSnowCover = list(options = list(variant = "MODIS_Terra_NDSI_Snow_Cover", 
                format = "png", maxZoom = 8L, opacity = 0.75)), 
            ModisTerraAOD = list(options = list(variant = "MODIS_Terra_Aerosol", 
                format = "png", maxZoom = 6L, opacity = 0.75)), 
            ModisTerraChlorophyll = list(options = list(variant = "MODIS_Terra_Chlorophyll_A", 
                format = "png", maxZoom = 7L, opacity = 0.75)))), 
    NLS = list(url = "https://nls-{s}.tileserver.com/nls/{z}/{x}/{y}.jpg", 
        options = list(attribution = "<a href=\"http://geo.nls.uk/maps/\">National Library of Scotland Historic Maps</a>", 
            bounds = structure(c(49.6, 61.7, -12, 3), dim = c(2L, 
            2L)), minZoom = 1L, maxZoom = 18L, subdomains = "0123")), 
    JusticeMap = list(url = "https://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png", 
        options = list(attribution = "<a href=\"http://www.justicemap.org/terms.php\">Justice Map</a>", 
            size = "county", bounds = structure(c(14L, 72L, -180L, 
            -56L), dim = c(2L, 2L))), variants = list(income = "income", 
            americanIndian = "indian", asian = "asian", black = "black", 
            hispanic = "hispanic", multi = "multi", nonWhite = "nonwhite", 
            white = "white", plurality = "plural")), GeoportailFrance = list(
        url = "https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}", 
        options = list(attribution = "<a target=\"_blank\" href=\"https://www.geoportail.gouv.fr/\">Geoportail France</a>", 
            bounds = structure(c(-75L, 81L, -180L, 180L), dim = c(2L, 
            2L)), minZoom = 2L, maxZoom = 18L, apikey = "choisirgeoportail", 
            format = "image/png", style = "normal", variant = "GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2"), 
        variants = list(plan = "GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2", 
            parcels = list(options = list(variant = "CADASTRALPARCELS.PARCELLAIRE_EXPRESS", 
                style = "PCI vecteur", maxZoom = 20L)), orthos = list(
                options = list(maxZoom = 19L, format = "image/jpeg", 
                  variant = "ORTHOIMAGERY.ORTHOPHOTOS")))), OneMapSG = list(
        url = "https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png", 
        options = list(variant = "Default", minZoom = 11L, maxZoom = 18L, 
            bounds = structure(c(1.56073, 1.16, 104.11475, 103.502
            ), dim = c(2L, 2L)), attribution = "<img src=\"https://docs.onemap.sg/maps/images/oneMap64-01.png\" style=\"height:20px;width:20px;\"/> New OneMap | Map data &copy; contributors, <a href=\"http://SLA.gov.sg\">Singapore Land Authority</a>"), 
        variants = list(Default = "Default", Night = "Night", 
            Original = "Original", Grey = "Grey", LandLot = "LandLot")), 
    USGS = list(url = "https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/tile/{z}/{y}/{x}", 
        options = list(maxZoom = 20L, attribution = "Tiles courtesy of the <a href=\"https://usgs.gov/\">U.S. Geological Survey</a>"), 
        variants = list(USTopo = structure(list(), names = character(0)), 
            USImagery = list(url = "https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/{z}/{y}/{x}"), 
            USImageryTopo = list(url = "https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryTopo/MapServer/tile/{z}/{y}/{x}"))), 
    WaymarkedTrails = list(url = "https://tile.waymarkedtrails.org/{variant}/{z}/{x}/{y}.png", 
        options = list(maxZoom = 18L, attribution = "Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href=\"https://waymarkedtrails.org\">waymarkedtrails.org</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-SA</a>)"), 
        variants = list(hiking = "hiking", cycling = "cycling", 
            mtb = "mtb", slopes = "slopes", riding = "riding", 
            skating = "skating")), OpenAIP = list(url = "https://{s}.tile.maps.openaip.net/geowebcache/service/tms/1.0.0/openaip_basemap@EPSG%3A900913@png/{z}/{x}/{y}.{ext}", 
        options = list(attribution = "<a href=\"https://www.openaip.net/\">openAIP Data</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\">CC-BY-NC-SA</a>)", 
            ext = "png", minZoom = 4L, maxZoom = 14L, tms = TRUE, 
            detectRetina = TRUE, subdomains = "12")), OpenSnowMap = list(
        url = "https://tiles.opensnowmap.org/{variant}/{z}/{x}/{y}.png", 
        options = list(minZoom = 9L, maxZoom = 18L, attribution = "Map data: {attribution.OpenStreetMap} & ODbL, &copy; <a href=\"https://www.opensnowmap.org/iframes/data.html\">www.opensnowmap.org</a> <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>"), 
        variants = list(pistes = "pistes")), AzureMaps = list(
        url = "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&language={language}&subscription-key={subscriptionKey}", 
        options = list(attribution = "See https://docs.microsoft.com/en-US/rest/api/maps/renderv2/getmaptilepreview for details.", 
            apiVersion = "2.0", variant = "microsoft.imagery", 
            subscriptionKey = "<insert your subscription key here>", 
            language = "en-US"), variants = list(MicrosoftImagery = "microsoft.imagery", 
            MicrosoftBaseDarkGrey = "microsoft.base.darkgrey", 
            MicrosoftBaseRoad = "microsoft.base.road", MicrosoftBaseHybridRoad = "microsoft.base.hybrid.road", 
            MicrosoftTerraMain = "microsoft.terra.main", MicrosoftWeatherInfraredMain = list(
                url = "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&timeStamp={timeStamp}&language={language}&subscription-key={subscriptionKey}", 
                options = list(timeStamp = "2021-05-08T09:03:00Z", 
                  attribution = "See https://docs.microsoft.com/en-US/rest/api/maps/renderv2/getmaptilepreview#uri-parameters for details.", 
                  variant = "microsoft.weather.infrared.main")), 
            MicrosoftWeatherRadarMain = list(url = "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&timeStamp={timeStamp}&language={language}&subscription-key={subscriptionKey}", 
                options = list(timeStamp = "2021-05-08T09:03:00Z", 
                  attribution = "See https://docs.microsoft.com/en-US/rest/api/maps/renderv2/getmaptilepreview#uri-parameters for details.", 
                  variant = "microsoft.weather.radar.main")))))
