% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureLayers.R
\name{addEsriFeatureLayer}
\alias{addEsriFeatureLayer}
\title{Adds an ArcGIS Feature Layer.}
\usage{
addEsriFeatureLayer(map, url, useServiceSymbology = FALSE,
  options = featureLayerOptions(), layerId = NULL, group = NULL,
  markerType = NULL, markerIcons = NULL, markerIconProperty = NULL,
  markerOptions = leaflet::markerOptions(), clusterOptions = NULL,
  clusterId = NULL, labelProperty = NULL,
  labelOptions = leaflet::labelOptions(), popupProperty = NULL,
  popupOptions = leaflet::popupOptions(), stroke = TRUE, color = "#03F",
  weight = 5, opacity = 0.5, fill = TRUE, fillColor = color,
  fillOpacity = 0.2, dashArray = NULL, smoothFactor = 1, noClip = FALSE,
  pathOptions = leaflet::pathOptions(), highlightOptions = NULL,
  fitBounds = FALSE)
}
\arguments{
\item{map}{The leaflet map}

\item{url}{url of the \href{http://resources.arcgis.com/en/help/arcgis-rest-api/index.html#/Feature_Service/02r3000000z2000000/}{FeatureService} or \href{http://resources.arcgis.com/en/help/arcgis-rest-api/index.html#/Map_Service/02r3000000w2000000/}{MapService}.}

\item{useServiceSymbology}{whether to use the symbology set when a service was published.}

\item{options}{options for the featurelayer}

\item{layerId}{A unique ID for the layer.}

\item{group}{The name of the group this layer should be added to.
the same parameter under \code{\link{addTiles}})}

\item{markerType}{The type of marker.  either 'marker' or 'circleMarker'}

\item{markerIcons}{Icons for Marker.}

\item{markerIconProperty}{The property of the feature to use for marker icon.
Can be a JS function which accepts a feature and returns an index of \code{markerIcons}.
In either case the result must be one of the indexes of markerIcons.}

\item{markerOptions}{The options for markers
Can be a single marker using \code{\link[leaflet]{makeIcon}}
or a list of markers using \code{\link[leaflet]{iconList}}}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{labelProperty}{The property to use for the label.
You can also pass in a JS function that takes in a feature and returns a text/HTML content.}

\item{labelOptions}{A Vector of \code{\link{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{popupProperty}{The property to use for popup content
You can also pass in a JS function that takes in a feature and returns a text/HTML content.}

\item{popupOptions}{A Vector of \code{\link{popupOptions}} to provide popups}

\item{stroke}{whether to draw stroke along the path (e.g. the borders of
polygons or circles)}

\item{color}{stroke color}

\item{weight}{stroke width in pixels}

\item{opacity}{stroke opacity (or layer opacity for tile layers)}

\item{fill}{whether to fill the path with color (e.g. filling on polygons or
circles)}

\item{fillColor}{fill color}

\item{fillOpacity}{fill opacity}

\item{dashArray}{a string that defines the stroke
\href{https://developer.mozilla.org/en/SVG/Attribute/stroke-dasharray}{dash
pattern}}

\item{smoothFactor}{how much to simplify the polyline on each zoom level
(more means better performance and less accurate representation)}

\item{noClip}{whether to disable polyline clipping}

\item{pathOptions}{Options for shapes}

\item{highlightOptions}{Options for highlighting the shape on mouse over.
you can use \code{\link[leaflet]{highlightOptions}()} to specify highlight}

\item{fitBounds}{Whether to set the maps bounds to fit the data in the featureLayer
options}
}
\description{
FeatureLayer is used to visualize, style, query and edit vector geographic data hosted in both ArcGIS Online and published using ArcGIS Server. Copyright text from the service is added to map attribution automatically.
}
