% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_lcsm_data.R
\name{sim_bi_lcsm}
\alias{sim_bi_lcsm}
\title{Simulate data from bivariate latent change score model parameter estimates}
\usage{
sim_bi_lcsm(
  timepoints,
  model_x,
  model_x_param = NULL,
  model_y,
  model_y_param = NULL,
  coupling,
  coupling_param = NULL,
  sample.nobs = 500,
  na_x_pct = 0,
  na_y_pct = 0,
  seed = NULL,
  ...,
  var_x = "x",
  var_y = "y",
  change_letter_x = "g",
  change_letter_y = "j",
  return_lavaan_syntax = FALSE
)
}
\arguments{
\item{timepoints}{See \link[lcsm]{specify_bi_lcsm}}

\item{model_x}{See \link[lcsm]{specify_bi_lcsm}}

\item{model_x_param}{List, specifying parameter estimates for the LCSM that has been specified in the argument '\code{model_x}':
\itemize{
\item{\strong{\code{gamma_lx1}}}: Mean of latent true scores x (Intercept),
\item{\strong{\code{sigma2_lx1}}}: Variance of latent true scores x,
\item{\strong{\code{sigma2_ux}}}: Variance of observed scores x,
\item{\strong{\code{alpha_g2}}}: Mean of change factor (g2),
\item{\strong{\code{alpha_g3}}}: Mean of change factor (g3),
\item{\strong{\code{sigma2_g2}}}: Variance of change factor (g2).
\item{\strong{\code{sigma2_g3}}}: Variance of change factor (g3),
\item{\strong{\code{sigma_g2lx1}}}: Covariance of change factor (g2) with the initial true score x (lx1),
\item{\strong{\code{sigma_g3lx1}}}: Covariance of change factor (g3) with the initial true score x (lx1),
\item{\strong{\code{sigma_g2g3}}}: Covariance of change factors (g2 and g2),
\item{\strong{\code{phi_x}}}: Autoregression of change scores x.
}}

\item{model_y}{See \link[lcsm]{specify_bi_lcsm}}

\item{model_y_param}{List, specifying parameter estimates for the LCSM that has been specified in the argument '\code{model_y}':
\itemize{
\item{\strong{\code{gamma_ly1}}}: Mean of latent true scores y (Intercept),
\item{\strong{\code{sigma2_ly1}}}: Variance of latent true scores y,
\item{\strong{\code{sigma2_uy}}}: Variance of observed scores y,
\item{\strong{\code{alpha_j2}}}: Mean of change factor (j2),
\item{\strong{\code{alpha_j3}}}: Mean of change factor (j3),
\item{\strong{\code{sigma2_j2}}}: Variance of change factor (j2).
\item{\strong{\code{sigma2_j3}}}: Variance of change factor (j3),
\item{\strong{\code{sigma_j2ly1}}}: Covariance of change factor (j2) with the initial true score x (ly1),
\item{\strong{\code{sigma_j3ly1}}}: Covariance of change factor (j3) with the initial true score x (ly1),
\item{\strong{\code{sigma_j2j3}}}: Covariance of change factors (j2 and j2),
\item{\strong{\code{phi_y}}}: Autoregression of change scores y.
}}

\item{coupling}{See \link[lcsm]{specify_bi_lcsm}}

\item{coupling_param}{List, specifying parameter estimates coupling parameters that have been specified in the argument '\code{coupling}':
\itemize{
\item{\strong{\code{sigma_su}}}: Covariance of residuals x and y,
\item{\strong{\code{sigma_ly1lx1}}}: Covariance of intercepts x and y,
\item{\strong{\code{sigma_g2ly1}}}: Covariance of change factor x (g2) with the initial true score y (ly1),
\item{\strong{\code{sigma_g3ly1}}}: Covariance of change factor x (g3) with the initial true score y (ly1),
\item{\strong{\code{sigma_j2lx1}}}: Covariance of change factor y (j2) with the initial true score x (lx1),
\item{\strong{\code{sigma_j3lx1}}}: Covariance of change factor y (j3) with the initial true score x (lx1),
\item{\strong{\code{sigma_j2g2}}}: Covariance of change factors y (j2) and x (g2),
\item{\strong{\code{sigma_j2g3}}}: Covariance of change factors y (j2) and x (g3),
\item{\strong{\code{sigma_j3g2}}}: Covariance of change factors y (j3) and x (g2),,
\item{\strong{\code{delta_con_xy}}}: Change score x (t) determined by true score y (t),
\item{\strong{\code{delta_con_yx}}}: Change score y (t) determined by true score x (t),
\item{\strong{\code{delta_lag_xy}}}: Change score x (t) determined by true score y (t-1),
\item{\strong{\code{delta_lag_yx}}}: Change score y (t) determined by true score x (t-1),
\item{\strong{\code{xi_con_xy}}}: Change score x (t) determined by change score y (t),
\item{\strong{\code{xi_con_yx}}}: Change score y (t) determined by change score x (t),
\item{\strong{\code{xi_lag_xy}}}: Change score x (t) determined by change score y (t-1),
\item{\strong{\code{xi_lag_yx}}}: Change score y (t) determined by change score x (t-1)
}}

\item{sample.nobs}{Numeric, number of cases to be simulated, see \link[lcsm]{specify_uni_lcsm}}

\item{na_x_pct}{Numeric, percentage of random missing values in the simulated dataset (0 to 1)}

\item{na_y_pct}{Numeric, percentage of random missing values in the simulated dataset (0 to 1)}

\item{seed}{Set seed for data simulation, see \link[lavaan]{simulateData}}

\item{...}{Arguments to be passed on to \link[lavaan]{simulateData}}

\item{var_x}{See \link[lcsm]{specify_bi_lcsm}}

\item{var_y}{See \link[lcsm]{specify_bi_lcsm}}

\item{change_letter_x}{See \link[lcsm]{specify_bi_lcsm}}

\item{change_letter_y}{See \link[lcsm]{specify_bi_lcsm}}

\item{return_lavaan_syntax}{Logical, if TRUE return the lavaan syntax used for simulating data. To make it look beautiful use the function \link[base]{cat}.}
}
\value{
tibble
}
\description{
This function simulate data from bivariate latent change score model parameter estimates using \link[lavaan]{simulateData}.
}
\examples{
# Simulate data from bivariate LCSM parameters 
sim_bi_lcsm(timepoints = 12, 
            na_x_pct = .05,
            na_y_pct = .1,
            model_x = list(alpha_constant = TRUE, beta = TRUE, phi = FALSE),
            model_x_param = list(gamma_lx1 = 21,
                                 sigma2_lx1 = .5,
                                 sigma2_ux = .2,
                                 alpha_g2 = -.4,
                                 sigma2_g2 = .4,
                                 sigma_g2lx1 = .2,
                                 beta_x = -.1),
            model_y = list(alpha_constant = TRUE, beta = TRUE, phi = TRUE),
            model_y_param = list(gamma_ly1 = 5,
                                 sigma2_ly1 = .2,
                                 sigma2_uy = .2,
                                 alpha_j2 = -.2,
                                 sigma2_j2 = .1,
                                 sigma_j2ly1 = .02,
                                 beta_y = -.2,
                                 phi_y = .1),
            coupling = list(delta_lag_xy = TRUE, 
                            xi_lag_yx = TRUE),
            coupling_param =list(sigma_su = .01,
                                 sigma_ly1lx1 = .2,
                                 sigma_g2ly1 = .1,
                                 sigma_j2lx1 = .1,
                                 sigma_j2g2 = .01,
                                 delta_lag_xy = .13,
                                 xi_lag_yx = .4),
            return_lavaan_syntax = FALSE)

}
\references{
Ghisletta, P., & McArdle, J. J. (2012). Latent Curve Models and Latent Change Score Models Estimated in R. Structural Equation Modeling: A Multidisciplinary Journal, 19(4), 651–682. \doi{10.1080/10705511.2012.713275}.

Grimm, K. J., Ram, N., & Estabrook, R. (2017). Growth Modeling—Structural Equation and Multilevel Modeling Approaches. New York: The Guilford Press.

Kievit, R. A., Brandmaier, A. M., Ziegler, G., van Harmelen, A.-L., de Mooij, S. M. M., Moutoussis, M., … Dolan, R. J. (2018). Developmental cognitive neuroscience using latent change score models: A tutorial and applications. Developmental Cognitive Neuroscience, 33, 99–117. \doi{10.1016/j.dcn.2017.11.007}.

McArdle, J. J. (2009). Latent variable modeling of differences and changes with longitudinal data. Annual Review of Psychology, 60(1), 577–605. \doi{10.1146/annurev.psych.60.110707.163612}.

Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2), 1-36.
\doi{10.18637/jss.v048.i02}.
}
