% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville_extreme.R
\name{hmvevdliouv}
\alias{hmvevdliouv}
\title{Spectral density of the CDA of survival copula and copula of Liouville vectors}
\usage{
hmvevdliouv(w, alpha, rho, CDA = c("C", "S"), logdensity = FALSE)
}
\arguments{
\item{w}{matrix of points in the unit simplex at which to evaluate the density}

\item{alpha}{vector of Dirichlet allocations (strictly positive).}

\item{rho}{parameter of limiting model corresponding to index of regular variation}

\item{CDA}{copula domain of attraction of either the Liouville copula, \code{C}, or its survival copula \code{S}}

\item{logdensity}{logical; whether to return the log density or not}
}
\value{
a vector with the same number of rows as \code{w}.
}
\description{
Computes the Liouville EV model or the scaled Dirichlet EV model spectral density
}
\examples{
hmvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(1,2), rho=0.2, CDA="C")
hmvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(0.1,2), rho=0.2, CDA="S")
hmvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(1,2), rho=0.2, CDA="S")
}
