% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{pliouv}
\alias{pliouv}
\title{Copula function for Liouville copulas}
\usage{
pliouv(pseudo, theta, family, alphavec)
}
\arguments{
\item{pseudo}{sample matrix from a Liouville copula}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}
}
\value{
a matrix of survival probabilities
}
\description{
Copula function for Liouville copulas
}
\examples{
x <- rliouv(n=100, family="frank", theta=1.5, alphavec=c(2,3))
pliouv(theta=1.5, pseudo=x,family="frank", alphavec=c(2,3))
}

