% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr.R
\name{expr_label}
\alias{expr_env}
\alias{expr_find}
\alias{expr_label}
\alias{expr_text}
\title{Find the expression associated with an argument}
\usage{
expr_label(x)

expr_text(x, width = 60L, nlines = Inf)

expr_find(x)

expr_env(x, default_env)
}
\arguments{
\item{x}{A promise (function argument)}

\item{width}{Width of each line}

\item{nlines}{Maximum number of lines to extract.}

\item{default_env}{If supplied, \code{expr_env} will return this if the
promise has already been forced. Otherwise it will throw an error.}
}
\description{
\code{expr_find()} finds the full expression; \code{expr_text()} turns the
expression into a single string; \code{expr_label()} formats it nicely for
use in messages. \code{expr_env()} finds the environment associated with
the expression.
}
\details{
These functions never force promises, and will work even if a promise has
previously been forced.
}
\examples{
# Unlike substitute(), expr_find() finds the original expression
f <- function(x) g(x)
g <- function(y) h(y)
h <- function(z) list(substitute(z), expr_find(z))

f(1 + 2 + 3)

expr_label(10)
# Names a quoted with ``
expr_label(x)
# Strings are encoded
expr_label("a\\nb")
# Expressions are captured
expr_label(a + b + c)
# Long expressions are collapsed
expr_label(foo({
  1 + 2
  print(x)
}))
}

