% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy.list.R
\name{lazy.list}
\alias{lazy.list}
\title{Lists in LaTeX and HTML}
\usage{
lazy.list(
  item,
  ordered = TRUE,
  counter = NULL,
  counterSet = 1,
  title = NULL,
  style = c("arabic", "Roman", "roman", "Alph", "alph"),
  symbol = c("bullet", "circ", "blacksquare"),
  font,
  family,
  size
)
}
\arguments{
\item{item}{A vector with the items to be placed in the list}

\item{ordered}{Denotes if the list is ordered or bulleted}

\item{counter}{For future inclusion.  Specifies what counter 
should be used for numbering.  Currently not in use}

\item{counterSet}{The value to which \code{counter} should 
be set.  In other words, the number for the first item in the 
list}

\item{title}{A title for the list}

\item{style}{A character string denoting how the ordered list 
should be numbered.  Options are \code{"arabic", "roman", 
"Roman", "alph", "Alph"}.}

\item{symbol}{A symbol for bulleted lists to be used as the bullet}

\item{font}{Font to be used in HTML documents.  Defaults to the 
font set in the options}

\item{family}{Font family to be used in HTML documents.  Defaults 
to the font family in the options}

\item{size}{Font size to be used in HTML documents.  Defaults to 
the font family in the options}
}
\description{
Produce code for lists in LaTeX documents
}
\details{
With \code{style}, the options produce the following and 
apply to both LaTeX and HTML:
\tabular{ll}{
  arabic \tab Arabic numbers\cr
  roman  \tab Lower case roman numerals (i, ii, iii, ...)\cr
  Roman  \tab Upper case roman numerals (I, II, III, ...)\cr
  alph   \tab Lower case alphabetic ordering (a, b, c, ...)\cr
  Alph   \tab Upper case alphabetic ordering (A, B, C, ...)\cr
}

The given options for \code{symbol} follow the HTML conventions, 
but when \code{options("lazyReportFormat")} is \code{"latex"}, 
these options are translated into the appropriate equivalent.
}
\examples{
\dontrun{
lazy.write(
  lazy.file.start(),
  lazy.text("A vector can be presented as a list as follows"),
  lazy.list(c("First item", "Second item", "Third item", 
              "Fourth item", "Fifth item"), style="Alph"),
  lazy.file.end(),
  OutFile="Example 1.tex")

unlink("Example 1.tex")
}

}
\author{
Benjamin Nutter
}
