% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean_crosses.R
\name{lawn_boolean_crosses}
\alias{lawn_boolean_crosses}
\title{Boolean crosses}
\usage{
lawn_boolean_crosses(feature1, feature2, lint = FALSE)
}
\arguments{
\item{feature1, feature2}{any \link{data-Geometry}/\link{data-Feature} objects}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a logical (\code{TRUE}/\code{FALSE})
}
\description{
Boolean crosses
}
\examples{
l1 <- '[[-2, 2], [4, 2]]'
l2 <- '[[1, 1], [1, 2], [1, 3], [1, 4]]'
lawn_boolean_crosses(lawn_linestring(l1), lawn_linestring(l2))
}
\seealso{
Other boolean functions: \code{\link{lawn_boolean_clockwise}},
  \code{\link{lawn_boolean_contains}},
  \code{\link{lawn_boolean_disjoint}},
  \code{\link{lawn_boolean_overlap}},
  \code{\link{lawn_boolean_pointonline}},
  \code{\link{lawn_boolean_within}}
}
\concept{boolean functions}
