% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average.R
\name{lawn_average}
\alias{lawn_average}
\title{Average of a field among points within polygons}
\usage{
lawn_average(polygons, points, in_field, out_field = "average",
  lint = FALSE)
}
\arguments{
\item{polygons}{Geojson \code{\link{data-Polygon}}'s}

\item{points}{Geojson \code{\link{data-Point}}'s}

\item{in_field}{(character) The field in the points features from which to pull
values to average}

\item{out_field}{(character) The field in polygons to put results of the
averages}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
polygons with the value of outField set to the calculated averages
}
\description{
Calculate the average value of a field for a set of \code{\link{data-Point}}'s
within a set of \code{\link{data-Polygon}}'s
}
\examples{
\dontrun{
# using data in the package
cat(lawn_data$points_average)
cat(lawn_data$polygons_average)
lawn_average(polygons = lawn_data$polygons_average,
             points = lawn_data$points_average, 'population')
}
}
\seealso{
Other aggregations: \code{\link{lawn_collect}},
  \code{\link{lawn_count}}, \code{\link{lawn_deviation}},
  \code{\link{lawn_max}}, \code{\link{lawn_median}},
  \code{\link{lawn_min}}, \code{\link{lawn_sum}},
  \code{\link{lawn_variance}}
}

