% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{coef2}
\alias{coef2}
\alias{.coef2}
\alias{.coef2.gls}
\alias{.coef2.lme}
\title{Export Mean and Variance Coefficients from a nlme Model}
\usage{
.coef2(object)

\method{.coef2}{gls}(object)

\method{.coef2}{lme}(object)
}
\arguments{
\item{object}{a \code{gls} or \code{lme} object.}
}
\value{
A numeric vector named with the names of the coefficient with three attributes:
\itemize{
\item mean.coef: the name of the mean coefficients.
\item var.coef: the name of the variance coefficients.
\item cor.coef:  the name of the correlation coefficients.
}
}
\description{
Export mean and variance coefficients from a nlme model.
}
\details{
The variance coefficients that are exported are the residual variance of each outcome. 
This is \eqn{\sigma^2} for the first one and \eqn{k^2 \sigma^2} for the remaining ones.
}
\concept{
extractor
}
\keyword{internal}
