% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryWithWarnings.R
\name{tryWithWarnings}
\alias{tryWithWarnings}
\title{Run an Expression and Catch Warnings and Errors}
\usage{
tryWithWarnings(expr)
}
\arguments{
\item{expr}{the line of code to be evaluated}
}
\value{
a list containing:
\itemize{
\item value the result of the evaluation of the expression
\item warnings warning(s) generated during the evaluation of the expression
\item error error generated during the evaluation of the expression
}
}
\description{
Similar to \code{try} but also returns warnings.
}
\details{
from https://stackoverflow.com/questions/4948361/how-do-i-save-warnings-and-errors-as-output-from-a-function
}
\examples{
FctTest <- function(x){
  return(log(x))
}
tryWithWarnings(FctTest(-1))
tryWithWarnings(FctTest(1))
tryWithWarnings(FctTest(xxxx))
' '
}
\author{
Brice Ozenne
}
