% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{lcModel}
\alias{lcModel}
\title{Longitudinal cluster result (\strong{\code{lcModel}})}
\description{
A longitudinal cluster model (\code{[lcModel][lcModel-class]}) describes the clustered representation of a certain longitudinal dataset.

A \code{lcModel} is obtained by estimating a specified \link[=lcMethod]{longitudinal cluster method} on a \link[=latrend-data]{longitudinal dataset}.
The estimation is done via one of the \link[=latrend-estimation]{latrend estimation functions}.

A longitudinal cluster result represents the dataset in terms of a partitioning of the trajectories into a number of clusters.
The \code{\link[=trajectoryAssignments]{trajectoryAssignments()}} function outputs the most likely membership for the respective trajectories.
Each cluster has a longitudinal representation, obtained via \code{\link[=clusterTrajectories]{clusterTrajectories()}}, and can be plotted via \code{\link[=plotClusterTrajectories]{plotClusterTrajectories()}}.
}
\section{Functionality}{

\strong{Clusters and partitioning:}
\itemize{
\item \code{\link[=nClusters]{nClusters()}}: The number of clusters this model represents.
\item \code{\link[=clusterNames]{clusterNames()}}: The names of the clusters.
\item \code{\link[=clusterSizes]{clusterSizes()}}: The respective number of trajectories assigned to each cluster.
\item \code{\link[=clusterProportions]{clusterProportions()}}: The respective proportional size of each cluster.
\item \code{\link[=trajectoryAssignments]{trajectoryAssignments()}}: The most likely cluster membership of each trajectory.
\item \code{\link[=postprob]{postprob()}}: The posterior probability of each trajectory to each cluster.
}

\strong{Longitudinal cluster representation (i.e., trends):}
\itemize{
\item \code{\link[=clusterTrajectories]{clusterTrajectories()}}: A \code{data.frame} containing the longitudinal representation of each cluster.
\item \code{\link[=plotClusterTrajectories]{plotClusterTrajectories()}}: Plots the longitudinal representation of each cluster.
\item \code{\link[=fittedTrajectories]{fittedTrajectories()}}: A \code{data.frame} containing the longitudinal representation of each trajectory. For many methods, this is the cluster center.
\item \code{\link[=plotFittedTrajectories]{plotFittedTrajectories()}}: Plot the trajectory representation.
}

\strong{Training data:}
\itemize{
\item \code{\link[=nIds]{nIds()}}: The number of trajectories used for estimation.
\item \code{\link[=ids]{ids()}}: A vector of identifiers of the trajectories that were used for estimation.
\item \code{\link[=nobs]{nobs()}}: The number of observations used for estimation, across trajectories.
\item \code{\link[=time]{time()}}: Moments in time on which observations are present.
\item \code{\link[=trajectories]{trajectories()}}: The trajectories that were used for estimation.
\item \code{\link[=plotTrajectories]{plotTrajectories()}}: Plot the trajectories that were used for estimation.
}

\strong{Model evaluation:}
\itemize{
\item \code{\link[=summary]{summary()}}: Obtain a summary of the model.
\item \code{\link[=metric]{metric()}}: Compute an internal metric.
\item \code{\link[=externalMetric]{externalMetric()}}: Compute an external metric in relation to a second \code{lcModel}.
\item \code{\link[=converged]{converged()}}: Whether the estimation procedure converged.
\item \code{\link[=estimationTime]{estimationTime()}}: Total time that was needed for the fitting steps.
\item \code{\link[=sigma]{sigma()}}: Residual error scale.
\item \code{\link[=qqPlot]{qqPlot()}}: QQ plot of the model residuals.
}

\strong{Model prediction:}
\itemize{
\item \code{\link[=predictForCluster]{predictForCluster()}}: Cluster-specific prediction on new data. Not supported for all methods.
\item \code{\link[=predictPostprob]{predictPostprob()}}: Predict posterior probability for new data. Not supported for all methods.
\item \code{\link[=predictAssignments]{predictAssignments()}}: Predict cluster membership for new data. Not supported for all methods.
}

\strong{Other functionality:}
\itemize{
\item \code{\link[=getLcMethod]{getLcMethod()}}: Get the \link[=lcMethod]{method specification} by which this model was estimated.
\item \code{\link[=update]{update()}}: Retrain a model with altered method arguments.
\item \code{\link[=strip]{strip()}}: Removes non-essential (meta) data and environments from the model to facilitate efficient serialization.
}
}

\examples{
data(latrendData)
# define the method
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
# estimate the method, giving the model
model <- latrend(method, data = latrendData)

if (require("ggplot2")) {
  plotClusterTrajectories(model)
}
}
\seealso{
\linkS4class{lcModel}
}
