% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lasvmTrain.R
\name{lasvmTrain}
\alias{lasvmTrain}
\title{lasvmTrain}
\usage{
lasvmTrain(x, y, gamma = 1, cost = 1, degree = 3, coef0 = 0,
  optimizer = 1, kernel = 2, selection = 0, termination = 0,
  sample = 1e+08, cachesize = 256, bias = 1, epochs = 1,
  epsilon = 0.001, verbose = FALSE)
}
\arguments{
\item{x}{data matrix}

\item{y}{labels}

\item{gamma}{RBF kernel parameter}

\item{cost}{regularization parameter}

\item{degree}{degree for poly kernel}

\item{coef0}{coefficient for poly kernel}

\item{optimizer}{type of optimizer}

\item{kernel}{kernel type}

\item{selection}{selection strategy}

\item{termination}{criterion for stopping}

\item{sample}{time for stopping/number of iterations tec}

\item{cachesize}{size of kernel cache}

\item{bias}{use  bias?}

\item{epochs}{number of epochs}

\item{epsilon}{stopping criterion parameter}

\item{verbose}{verbose output?}
}
\value{
a list consisting of
	alpha		alpha for SVs as vector
	SV		support vectors as matrix
}
\description{
Use lasvm to train a given problem.
}
\examples{
model = lasvmR::lasvmTrain (x = as.matrix(iris[seq(1,150,2),1:4]),
	y = (as.numeric(iris[seq(1,150,2),5]) \%\% 2)*2-1,
	gamma = 1,
	cost = 1,
	kernel = 2)
ytrue = (as.numeric(iris[seq(2,150,2),5]) \%\% 2)*2-1
result = lasvmPredict (x = as.matrix(iris[seq(2,150,2),1:4]), model)
ypred = result$predictions
error = sum(abs(ypred - ytrue))/length(ytrue)
cat ("Error rate =", error*100)
}

