% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{chr2num}
\alias{chr2num}
\alias{chr2logical}
\alias{chr2date}
\title{Check character values for date/numeric/logical and change datatype}
\usage{
chr2num(data)

chr2logical(data)

chr2date(data)
}
\arguments{
\item{data}{Vector, data.frame or list}
}
\description{
Automatically check a vector, data.frame or list for numeric, logical,
date content and change their datatype. Note that factors are skipped in
case the user requires character numeric values to be kept as they are.
}
\examples{
str(chr2num(c("1", "2", "3")))
df <- data.frame(A = c("1", "3"), B = c("A", "B"), c = c(pi, pi*2))
str(chr2num(df))
lst <- list(A = c("1", "2", "3"), B = c("A", "B", "3"), C = pi, D = 3L)
str(chr2num(lst))
lst2 <- list(layer1 = ":D", layer2 = lst)
str(chr2num(lst2))
str(chr2logical(c(NA, "true", FALSE)))
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
