% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{try_require}
\alias{try_require}
\title{Check if Specific Package is Installed}
\usage{
try_require(package, stop = TRUE, load = TRUE, ...)
}
\arguments{
\item{package}{Character. Name of the library}

\item{stop}{Boolean. Stop if not installed. If \code{FALSE} and
library is not available, warning will be shown.}

\item{load}{Boolean. Load library?}

\item{...}{Enabled lazyeval to ignore shared parameters.}
}
\value{
No return value, called for side effects.
}
\description{
This function checks library dependencies
}
\examples{
# Check if library base is installed. If not, stop and show error
try_require("base", stop = TRUE)
# Check if library xxx is installed. If not, show warning
try_require("xxx", stop = FALSE)
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}
}
\concept{Tools}
