% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{textFeats}
\alias{textFeats}
\title{Create features out of text}
\usage{
textFeats(text, auto = TRUE, contains = NA, prc = FALSE)
}
\arguments{
\item{text}{Character vector}

\item{auto}{Boolean. Auto create some useful parameters?}

\item{contains}{Character vector. Which columns do you wish to add
with a contains (counter) string validator?}

\item{prc}{Boolean. Also add percentage of each column compared with length?}
}
\value{
data.frame with additional features based on \code{text}.
}
\description{
This function creates a data.frame with features based on a text vector
}
\examples{
textFeats("Bernardo Lares")
textFeats("Bernardo Lares 123!", prc = TRUE)
textFeats("I'm 100\% Lares...", contains = c("Lares", "lares"))
textFeats(c("GREAT library!!", "Have you tried this 2?", "Happy faces :D :-)"))
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{year_week}()}

Other Text Mining: 
\code{\link{cleanNames}()},
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Data Wrangling}
\concept{Text Mining}
