% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_shdi.R
\name{lsm_l_shdi}
\alias{lsm_l_shdi}
\title{SHDI (landscape level)}
\usage{
lsm_l_shdi(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}
}
\value{
tibble
}
\description{
Shannon's diversity index (Diversity metric)
}
\details{
\deqn{SHDI = - \sum \limits_{i = 1}^{m} (P_{i} * \ln P_{i})}
where \eqn{P_{i}} is the proportion of class i.

SHDI is a 'Diversity metric'. It is a widely used metric in biodiversity and ecology
and takes both the number of classes and the abundance of each class into account.

\subsection{Units}{None}
\subsection{Range}{SHDI >= 0}
\subsection{Behaviour}{Equals SHDI = 0 when only one patch is present and increases,
without limit, as the number of classes increases while the proportions are
equally distributed}
}
\examples{
lsm_l_shdi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Shannon, C., and W. Weaver. 1949. The mathematical theory of
communication. Univ. IllinoisPress, Urbana
}
\seealso{
\code{\link{lsm_c_pland}}
}
