% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_siei.R
\name{lsm_l_siei}
\alias{lsm_l_siei}
\alias{lsm_l_siei.RasterLayer}
\alias{lsm_l_siei.RasterStack}
\alias{lsm_l_siei.RasterBrick}
\alias{lsm_l_siei.list}
\title{SIEI (landscape level)}
\usage{
lsm_l_siei(landscape, directions)

\method{lsm_l_siei}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_siei}{RasterStack}(landscape, directions = 8)

\method{lsm_l_siei}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_siei}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Simpson's evenness index (Diversity metric)
}
\details{
\deqn{SIEI = \frac{1 - \sum \limits_{i = 1}^{m} P_{i}^{2}} {1 - \frac{1} {m}}}
where \eqn{P_{i}} is the proportion of class i and \eqn{m} is the
number of classes.

SIEI is a 'Diversity metric'. The metric is widely used in biodiversity and ecology.
It is the ratio between the actual Simpson's diversity  index and the theoretical maximum
Simpson's diversity index.

\subsection{Units}{None}
\subsection{Range}{0 < SIEI <= 1}
\subsection{Behaviour}{Equals SIEI = 0 when only one patch is present and approaches
SIEI = 1 when the number of class types increases while the proportions are
equally distributed}
}
\examples{
lsm_l_siei(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Simpson, E. H. 1949. Measurement of diversity. Nature 163:688
}
\seealso{
\code{\link{lsm_c_pland}},
\code{\link{lsm_l_pr}}
}
