% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land8tools.R
\name{reflconv}
\alias{reflconv}
\title{Conversion to TOA Reflectance}
\usage{
reflconv(x, Mp, Ap)
}
\arguments{
\item{x}{Image to be converted, in matrix, data frame, or SpatialGridDataFrame format.}

\item{Mp}{Band specific multiplicative rescaling factor from the metadata (MTL file) (REFLECTANCE_MULT_BAND_x, where x is the band number).}

\item{Ap}{Band specific additive rescaling factor from the metadata (MTL file) (REFLECTANCE_ADD_BAND_x, where x is the band number).}
}
\value{
TOA spectral radiance.
}
\description{
Conversion to TOA reflectance of satellite data.
}
\examples{
data(band5)
band5.dn<- as(band5, 'SpatialGridDataFrame')
band5.refl<-reflconv(band5.dn,2.0000E-05,-0.100000)
}
\author{
Alexandre dos Santos
}
\references{
U.S. Geological Survey. 2015.
            Landsat 8 (L8) data users handbook. Version 1.0. 97p.
}

