% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_slides.R
\name{new_slide}
\alias{new_slide}
\title{Add a new slide to a presentation}
\usage{
new_slide(
  presentation_id,
  layout,
  centered_title = NULL,
  subtitle = NULL,
  title = NULL,
  body = NULL
)
}
\arguments{
\item{presentation_id}{The presentation id}

\item{layout}{The layout to use for the slide. See \link{get_layouts}.}

\item{centered_title}{Character vector to be inserted into the "centered_title" placeholders in
order as for \code{title}}

\item{subtitle}{Character vector to be inserted into the subtitle placeholders in order as for
\code{title}}

\item{title}{Character vector to be inserted into the title placeholders in order. Any \code{NA}
entries will be skip the corresponding placeholder.}

\item{body}{Character vector to be inserted into the body placeholders in order as for \code{title}}
}
\value{
The URL of the new slide.
This function is mostly used for its side effect of adding a slide to the presentation.
}
\description{
Add a new slide to a presentation
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
s <- create_slides()
layout <- get_layouts(s)
layout_p9 <- layout$layout_objectId[20]
new_slide(s, layout_p9, title = "Slide Title", subtitle = "A Subtitle", body = "Body Text")
\dontshow{\}) # examplesIf}
}
