% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_irregular.R
\name{check_irregular}
\alias{check_irregular}
\title{Check Vector for "Irregular" Values}
\usage{
check_irregular(
  x,
  nan.include = TRUE,
  inf.include = TRUE,
  special = c("NA", "NAN", "INF", "-INF"),
  other = NULL,
  any = FALSE
)
}
\arguments{
\item{x}{an atomic vector to checked for the presence of (any) NA values.}

\item{nan.include}{treat NaN values as NA (i.e., return TRUE if present).}

\item{inf.include}{treat Inf and -Inf values as NA (i.e., return TRUE if
present).}

\item{special}{a modifiable set of default character values that will be
treated as equivalent to NA values (i.e., will return TRUE if present).}

\item{other}{an argument for additional values of arbitrary but consistent
class (e.g., all numeric, all character) that will be treated as equivalent
to NA values (i.e., \code{check_irregular} will return TRUE where/if found).}

\item{any}{if TRUE, return a 1L vector that is TRUE if any irregular/NA-esque
value is found in the vector x, FALSE if no such value is found; if
any=FALSE, function will return a logical value for every element of x
(TRUE if that specific value meets the "irregular"-ity test).}
}
\value{
A logical vector (1L if any==TRUE; length of x if any==FALSE).
}
\description{
Check a vector for the presence of "irregular" values, defined as NA values,
other arbitrary values you specify, and (by default): NaN, Inf, -Inf, and
character variants of same (i.e., upper, lower, or mixed-case variants of
"NA","NAN","INF","-INF").
}
\details{
\code{check_irregular} is used by core labelr functions (e.g., \code{add_val_labs}) to
ensure that NA and other irregular (e.g., Inf) values are handled in a simple
and consistent -- and, hence, rigid -- fashion. It is not intended as a user-
facing command as part of a labelr data-analytic workflow, though it may be
useful in other applications where one wishes to test a vector against a
focal and user-extensible class of NA-esque (or other) offending values.
}
\examples{
# below is TRUE, because there is nothing NA-like in this vector
check_irregular(1:10) # FALSE

# below is TRUE, because we're treating 99 as "NA-esque"
check_irregular(1:100, other = 99)

# below is TRUE, because of NA val
check_irregular(c(1:100, NA))

# below is TRUE, because nan.include is on (by default)
check_irregular(c(1:100, NaN), nan.include = TRUE)

# below is TRUE, because inf.include is on (by default)
check_irregular(c(1:100, Inf), inf.include = TRUE)

# below is TRUE, because inf.include is on (by default)
check_irregular(c(1:100, -Inf), inf.include = TRUE)

# below is FALSE, it's just letters
check_irregular(letters)

# below is TRUE - see default vals for arg special (function not case-sens)
check_irregular(c(letters, "NA"))

# below is TRUE - see default vals for arg special (function not case-sens)
check_irregular(c(letters, "NAN"))

# below is TRUE - see default vals for arg special (function not case-sens)
check_irregular(c(letters, "-iNf"))

# below is FALSE, search for irregular vals is not substring/regex-based
check_irregular(c(letters, "nan-iNf"))
}
