% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwb.hantush.R
\name{baseProperties}
\alias{baseProperties}
\title{Hantush equation base properties}
\usage{
baseProperties(time = 10, basinWidth = 10, basinLength = 10,
  infiltrationRate = 0.5, horizConductivity = 10, iniHead = 10,
  specificYield = 0.2, numberTimeSteps = 150)
}
\arguments{
\item{time}{time elapsed since recharge began (T), (Default: 1.5 days)}

\item{basinWidth}{half width of the recharge basin (L), (Default: 10 m)}

\item{basinLength}{half length of the recharge basin (L), (Default: 10 m)}

\item{infiltrationRate}{recharge (infiltration) rate (L/T), (Default: 0.5 m/d)}

\item{horizConductivity}{horizontal hydraulic conductivity (L/T), (Default: 10 m/d)}

\item{iniHead}{initial head (height of the water table above the base of the
aquifer);(L), (Default: 10)}

\item{specificYield}{specific yield (Default: 0.2)}

\item{numberTimeSteps}{number of time steps to be used for average aquifer
thickness calculation (Default: 150)}
}
\value{
Base properties for Hantush equation
}
\description{
Hantush equation base properties
}
\references{
p.22, \url{https://pubs.usgs.gov/sir/2010/5102/support/sir2010-5102.pdf}
}
