% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmgenerate.R
\name{kmgenerate}
\alias{kmgenerate}
\title{Generate a knowledge structure from a set of response patterns}
\usage{
kmgenerate(x, threshold = 0)
}
\arguments{
\item{x}{Binary matrix representing a data set}

\item{threshold}{Threshold for taking response patterns as knowledge states (default 0)}
}
\value{
Binary matrix representing the generated knowledge structure
}
\description{
\code{kmgenerate} returns a matrix representing a knowledge structure generated
from data. It uses a simplistic approach: patterns with a frequency above a
specified threshold are considered as knowledge states.
If the specified threshold is 0 (default) a real threshold is computed as
N (number of  response patterns) divided by 2^|Q|.
Please note that the number of response patterns should be much higher than the
size of the power set of the item set Q. A factor of art least 10 is recommended.
Currently, the number of items is limited to the number of bits in a C long
minus one (i.e. 31 under Windows and 63 otherwise). But we would probably run into
memory problems way earlier anyway.
}
\examples{
kmgenerate(xpl$sim, 15)

}
\keyword{math}
