% Generated by roxygen2 (4.0.2): do not edit by hand
\name{kselection}
\alias{kselection}
\title{Selection of K in K-means Clustering}
\usage{
kselection(x, max_centers = 15, k_threshold = 0.85, nstart = 25,
  trace = FALSE, ...)
}
\arguments{
\item{x}{numeric matrix of data, or an object that can be coerced to such a
matrix.}

\item{max_centers}{maximum number of clusters for evaluation.}

\item{k_threshold}{maximum value of \eqn{f(K)} from which can not be
considered the existence of more than one cluster in the data set.
The default value is 0.85.}

\item{nstart}{the number of random sets that should be chosen in the kmeans
method.}

\item{trace}{show a progress bar.}

\item{...}{arguments to be passed to the kmeans method.}
}
\value{
an object with the \eqn{f(K)} results.
}
\description{
Selection of k in k-means clustering based on Pham et al. paper.
}
\details{
This function implements the method proposed by Pham, Dimov and Nguyen for
selecting the number of clusters for the K-means algorithm. In this method
a function \eqn{f(K)} is used to evaluate the quality of the resulting
clustering and help decide on the optimal value of \eqn{K} for each data
set. The \eqn{f(K)} function is defined as
\deqn{f(K) = \left\{
\begin{array}{rl}
 1 & \mbox{if $K = 1$} \\
 \frac{S_K}{\alpha_K S_{K-1}} & \mbox{if $S_{K-1} \ne 0$, $\forall K >1$} \\
 1 & \mbox{if $S_{K-1} = 0$, $\forall K >1$}
\end{array} \right.}{f(K) =
 1, if K = 1;
 (S_K)/(\alpha_K S_{K-1}, if S_{K-1} \ne 0, forall K >1;
 1, if S_{K-1} = 0, forall K > 1}
where \eqn{S_K} is the sum of the distortion of all cluster and \eqn{\alpha_K}
is a weight factor which is defined as
\deqn{\alpha_K = \left\{
\begin{array}{rl}
 1 - \frac{3}{4 N_d}                        & \mbox{if $K = 1$ and $N_d > 1$} \\
 \alpha_{K-1} + \frac{1 - \alpha_{K-1}}{6}  & \mbox{if $K > 2$ and $N_d > 1$}
\end{array} \right.}{\alpha_K =
 1 - 3/(4 * N_d), if K = 1 and N_d > 1;
 \alpha_{K-1} + (1 - \alpha_{K-1})/6, if K > 2 and N_d > 1}
where \eqn{N_d} is the number of dimensions of the data set.

In this definition \eqn{f(K)} is the ratio of the real distortion to the
estimated distortion and decreases when there are areas of concentration in
the data distribution.

The values of \eqn{K} that yield \eqn{f(K) < 0.85} can be recommended for
clustering. If there is not a value of \eqn{K} which \eqn{f(K) < 0.85}, it
cannot be considered the existence of clusters in the data set.
}
\examples{
# Create a data set with two clusters
dat <- matrix(c(rnorm(100, 2, .1), rnorm(100, 3, .1),
                rnorm(100, -2, .1), rnorm(100, -3, .1)), 200, 2)

# Ejecute the method
sol <- kselection(dat)

# Get the results
k   <- num_clusters(sol) # optimal number of clustes
f_k <- get_f_k(sol)      # the f(K) vector

# Plot the results
plot(sol)
}
\author{
Daniel Rodriguez Perez
}
\references{
D T Pham, S S Dimov, and C D Nguyen, "Selection of k in k-means clustering",
Mechanical Engineering Science, 2004, pp. 103-119.
}
\seealso{
\code{\link{num_clusters}}, \code{\link{get_f_k}}
}

