% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dale.chall.R
\name{dale.chall}
\alias{dale.chall}
\title{Readability: Dale-Chall Readability Formula}
\usage{
dale.chall(txt.file, word.list, parameters = c(const = 64, dword = 0.95, asl =
  0.69), ...)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus]{kRp.tagged-class}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{word.list}{A vector or matrix (with exactly one column) which defines familiar words. For valid results
the long Dale-Chall list with about 3000 words should be used.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for the index.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
Calculates the New Dale-Chall Readability Formula. In contrast to \code{\link[koRpus:readability]{readability}},
which by default calculates all possible indices,
      this function will only calculate the index value.

If \code{parameters="PSK"}, the parameters by Powers-Sumner-Kearl (1958) are used, and if
\code{parameters="old"}, the original parameters by Dale-Chall (1948), respectively.

This formula doesn't need syllable count.
}
\examples{
\dontrun{
dale.chall(tagged.text, word.list=new.dale.chall.wl)
}
}
\keyword{readability}

