% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{progress_estimated}
\alias{progress_estimated}
\title{Progress bar with estimated time.}
\usage{
progress_estimated(n, min_time = 0,
  progress_location = make_kpb_output_decisions())
}
\arguments{
\item{n}{Total number of items}

\item{min_time}{Progress bar will wait until at least \code{min_time}
seconds have elapsed before displaying any results.}

\item{progress_location}{where to write the progress to. Default is to make
decisions based on location type using \code{make_kpb_output_decisions()}.}
}
\value{
A ref class with methods \code{tick()}, \code{print()},
\code{pause()}, and \code{stop()}.
}
\description{
This provides a reference class representing a text progress bar that displays the
estimated time remaining. When finished, it displays the total duration.  The
automatic progress bar can be disabled by setting \code{progress_location = NULL}.
}
\examples{
p <- progress_estimated(3)
p$tick()
p$tick()
p$tick()

p <- progress_estimated(3)
for (i in 1:3) p$pause(0.1)$tick()$print()

p <- progress_estimated(3)
p$tick()$print()$
 pause(1)$stop()

# If min_time is set, progress bar not shown until that many
# seconds have elapsed
p <- progress_estimated(3, min_time = 3)
for (i in 1:3) p$pause(0.1)$tick()$print()

\dontrun{
p <- progress_estimated(10, min_time = 3)
for (i in 1:10) p$pause(0.5)$tick()$print()

# output to stderr
p <- progress_estimated(10, progress_location = stderr())

# output to a file
p <- progress_estimated(10, progress_location = tempfile(fileext = ".log"))
}

}
\seealso{
\code{\link[=make_kpb_output_decisions]{make_kpb_output_decisions()}}
}
