% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_groups.R
\name{compare_groups}
\alias{compare_groups}
\title{Compare groups}
\usage{
compare_groups(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  sigfigs = 3,
  stats = "basic",
  cohen_d = TRUE,
  cohen_d_w_ci = TRUE,
  adjust_p = "holm",
  bonferroni = NULL,
  mann_whitney = TRUE,
  t_test_stats = TRUE,
  t_test_df_decimals = 1,
  round_p = 3,
  save_as_png = FALSE,
  png_name = NULL,
  xlab = NULL,
  ylab = NULL,
  x_limits = NULL,
  x_breaks = NULL,
  x_labels = NULL,
  width = 5000,
  height = 3600,
  units = "px",
  res = 300,
  layout_matrix = NULL,
  col_names_nicer = TRUE,
  convert_dv_to_numeric = TRUE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable (grouping variable)}

\item{dv_name}{name of the dependent variable (measure variable
of interest)}

\item{sigfigs}{number of significant digits to round to}

\item{stats}{statistics to calculate for each group.
If \code{stats = "basic"},
group size, mean, standard deviation, median, minimum, and maximum will
be calculated. If \code{stats = "all"}, in addition to the
aforementioned statistics, standard error, 95\% confidence and
prediction intervals, skewness, and kurtosis will also be calculated.
The \code{stats} argument can also be a character vector with types of
statistics to calculate. For example, entering
\code{stats = c("mean", "median")} will calculate mean and median.
By default, \code{stats = "basic"}}

\item{cohen_d}{if \code{cohen_d = TRUE}, Cohen's d statistics will be
included in the pairwise comparison data.table.}

\item{cohen_d_w_ci}{if \code{cohen_d_w_ci = TRUE},
Cohen's d with 95\% CI will be included in the output data.table.}

\item{adjust_p}{the name of the method to use to adjust p-values.
If \code{adjust_p = "holm"}, the Holm method will be used;
if \code{adjust_p = "bonferroni"}, the Bonferroni method will be used.
By default, \code{adjust_p = "holm"}}

\item{bonferroni}{The use of this argument is deprecated.
Use the 'adjust_p' argument instead.
If \code{bonferroni = TRUE}, Bonferroni tests will be
conducted for t-tests or Mann-Whitney tests.}

\item{mann_whitney}{if \code{TRUE}, Mann-Whitney test results will be
included in the pairwise comparison data.table.
If \code{FALSE}, Mann-Whitney tests will not be performed.}

\item{t_test_stats}{if \code{t_test_stats = FALSE}, t-test statistic
and degrees of freedom will be excluded in the pairwise comparison
data.table.}

\item{t_test_df_decimals}{number of decimals for the degrees of freedom
in t-tests (default = 1)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{save_as_png}{if \code{save_as_png = "all"} or
if \code{save_as_png = TRUE},
the histogram by group, descriptive statistics by group,
and pairwise comparison results will be saved as a PNG file.}

\item{png_name}{name of the PNG file to be saved. By default, the name
will be "compare_groups_results_" followed by a timestamp of the
current time.
The timestamp will be in the format, jan_01_2021_1300_10_000001,
where "jan_01_2021" would indicate January 01, 2021;
1300 would indicate 13:00 (i.e., 1 PM); and 10_000001 would
indicate 10.000001 seconds after the hour.}

\item{xlab}{title of the x-axis for the histogram by group.
If \code{xlab = FALSE}, the title will be removed. By default
(i.e., if no input is given), \code{dv_name} will be used as
the title.}

\item{ylab}{title of the y-axis for the histogram by group.
If \code{ylab = FALSE}, the title will be removed. By default
(i.e., if no input is given), \code{iv_name} will be used as
the title.}

\item{x_limits}{a numeric vector with values of the endpoints
of the x axis.}

\item{x_breaks}{a numeric vector indicating the points at which to
place tick marks on the x axis.}

\item{x_labels}{a vector containing labels for the place tick marks
on the x axis.}

\item{width}{width of the PNG file (default = 5000)}

\item{height}{height of the PNG file (default = 3600)}

\item{units}{the units for the \code{width} and \code{height} arguments.
Can be \code{"px"} (pixels), \code{"in"} (inches), \code{"cm"},
or \code{"mm"}. By default, \code{units = "px"}.}

\item{res}{The nominal resolution in ppi which will be recorded
in the png file, if a positive integer. Used for units
other than the default. By default, \code{res = 300}}

\item{layout_matrix}{The layout argument for arranging plots and tables
using the \code{grid.arrange} function.}

\item{col_names_nicer}{if \code{col_names_nicer = TRUE}, column names
will be converted from snake_case to an easier-to-eye format.}

\item{convert_dv_to_numeric}{logical. Should the values in the
dependent variable be converted to numeric for plotting the
histograms? (default = TRUE)}

\item{holm}{if \code{holm = TRUE}, the relevant p values will be
adjusted using Holm method (also known as the Holm-Bonferroni or
Bonferroni-Holm method)}
}
\value{
the output will be a list of (1) ggplot object
(histogram by group) (2) a data.table with descriptive statistics by
group; and (3) a data.table with pairwise comparison results.
If \code{save_as_png = TRUE}, the plot and tables will be also saved
on local drive as a PNG file.
}
\description{
Compares groups by (1) creating histogram by group; (2) summarizing
descriptive statistics by group; and (3) conducting pairwise
comparisons (t-tests and Mann-Whitney tests).
}
\examples{
\dontrun{
compare_groups(data = iris, iv_name = "Species", dv_name = "Sepal.Length")
compare_groups(data = iris, iv_name = "Species", dv_name = "Sepal.Length",
x_breaks = 4:8)
}
}
