% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized_regression.R
\name{standardized_regression}
\alias{standardized_regression}
\title{Standardized Regression}
\usage{
standardized_regression(
  data = NULL,
  formula = NULL,
  reverse_code_vars = NULL,
  sigfigs = NULL,
  round_digits_after_decimal = NULL,
  round_p = 3,
  pretty_round_p_value = TRUE,
  return_table_upper_half = FALSE,
  round_r_squared = 3,
  round_f_stat = 2,
  prettify_reg_table_col_names = TRUE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{formula}{a formula object for the regression equation}

\item{reverse_code_vars}{names of binary variables to reverse code}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}

\item{round_p}{number of decimal places to which to round p-values
(default = 3)}

\item{pretty_round_p_value}{logical. Should the p-values be rounded
in a pretty format (i.e., lower threshold: "<.001").
By default, \code{pretty_round_p_value = TRUE}.}

\item{return_table_upper_half}{logical. Should only the upper part
of the table be returned?
By default, \code{return_table_upper_half = FALSE}.}

\item{round_r_squared}{number of digits after the decimal both r-squared
and adjusted r-squared values should be rounded to (default 3)}

\item{round_f_stat}{number of digits after the decimal the f statistic
of the regression model should be rounded to (default 2)}

\item{prettify_reg_table_col_names}{logical. Should the column names
of the regression table be made pretty (e.g., change "std_beta" to
"Std. Beta")? (Default = \code{TRUE})}
}
\value{
the output will be a data.table showing multiple regression
results.
}
\description{
This function standardizes all variables for a regression analysis
(i.e., dependent variable and all independent variables) and then
conducts a regression with the standardized variables.
}
\examples{
\donttest{
standardized_regression(data = mtcars, formula = mpg ~ gear * cyl)
standardized_regression(
data = mtcars, formula = mpg ~ gear + gear:am + disp * cyl,
round_digits_after_decimal = 3)
}
}
