% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicated_values.R
\name{duplicated_values}
\alias{duplicated_values}
\title{Duplicated values in a vector}
\usage{
duplicated_values(vector = NULL, na.rm = TRUE, sigfigs = 2, output = "summary")
}
\arguments{
\item{vector}{a vector whose elements will be checked for duplicates}

\item{na.rm}{logical. If \code{na.rm = TRUE}, NA values in the vector
will be removed before searching for duplicates.
If \code{na.rm = FALSE}, NA values will be included in the search
as potentially duplicated values. By default, \code{na.rm = TRUE}.}

\item{sigfigs}{number of significant digits to round to in
the percent column of the summary (default = 2)}

\item{output}{type of output. If \code{output = "summary"}, the function's
output will be a data.table summarizing duplicated values and
their counts. If \code{output = "duplicated_values"}, the function's
output will be a vector of duplicated values.
If \code{output = "non_duplicated_values"}, the function's output will
be a vector of non-duplicated values (default = "summary")}
}
\value{
the output will be a data.table object (summary),
a vector of duplicated values, or a vector non-duplicated values.
}
\description{
Return all duplicated values in a vector. This function is a copy of
the earlier function, find_duplicates, in Package 'kim'
}
\examples{
duplicated_values(mtcars$cyl)
duplicated_values(mtcars$cyl, output = "duplicated_values")
duplicated_values(vector = c(mtcars$cyl, 11:20, NA, NA))
duplicated_values(vector = c(mtcars$cyl, 11:20, NA, NA), na.rm = FALSE)
duplicated_values(vector = c(mtcars$cyl, 11:20, NA, NA),
na.rm = FALSE, sigfigs = 4, output = "duplicated_values")
}
