% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_color_picker}
\alias{palette_color_picker}
\alias{palette_colour_picker}
\title{Color Mapping}
\usage{
palette_color_picker(
  scheme,
  domain = NULL,
  midpoint = NULL,
  ordered = FALSE,
  missing = NULL,
  ...
)

palette_colour_picker(
  scheme,
  domain = NULL,
  midpoint = NULL,
  ordered = FALSE,
  missing = NULL,
  ...
)
}
\arguments{
\item{scheme}{A \code{\link{character}} string giving the name of the scheme to be
used (see \code{\link[=color]{color()}}).}

\item{domain}{A \code{\link{numeric}} range or a vector of categorical data specifying
the possible values that can be mapped.}

\item{midpoint}{A length-one \code{\link{numeric}} vector specifying the mid-point of
input range.}

\item{ordered}{A \code{\link{logical}} scalar: should the levels be treated as already
in the correct order?}

\item{missing}{The color to return for \code{NA} values.}

\item{...}{Further parameters to be passed to \code{\link[=color]{color()}}.}
}
\value{
A palette \code{\link{function}} that when called with a single argument returns
a \code{\link{character}} vector of colors.
}
\description{
Maps values to colors.
}
\details{
A wrapper around \code{palette_color_continuous()} and
\code{palette_color_discrete()}.
}
\examples{
## Visualize a simple DEM model
## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## Build palette functions
ramp_BuRd <- palette_color_picker("BuRd")

(col <- ramp_BuRd(elevation$breaks))
image(volcano, col = col)
legend("topright", legend = elevation$breaks, fill = col)

## Rescale to midpoint
ramp_BuRd <- palette_color_picker("BuRd", midpoint = 160)

(col <- ramp_BuRd(elevation$breaks))
image(volcano, col = col)
legend("topright", legend = elevation$breaks, fill = col)
}
\seealso{
Other palettes: 
\code{\link{palette_color_continuous}()},
\code{\link{palette_color_discrete}()},
\code{\link{palette_shape}()},
\code{\link{palette_size_range}()}
}
\concept{palettes}
