% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{calc_seawater_correction}
\alias{calc_seawater_correction}
\title{Kgen seawater composition correction function}
\usage{
calc_seawater_correction(
  k,
  sal,
  temp_c,
  magnesium = 0.0528171,
  calcium = 0.0102821,
  method = "r_polynomial"
)
}
\arguments{
\item{k}{K to be calculated}

\item{sal}{Salinity}

\item{temp_c}{Temperature (Celcius)}

\item{magnesium}{magnesium concentration in mol/kgsw. If None, modern is assumed (0.0528171). Should be the average magnesium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{calcium}{calcium concentration in mol/kgsw. If None, modern is assumed (0.0102821). Should be the average calcium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{method}{string describing method which should be either 'myami', 'myami_polynomial', or 'r_polynomial' (Default: 'r_polynomial').}
}
\value{
list of seawater correction factors
}
\description{
Kgen seawater composition correction function
}
\author{
Dennis Mayk
}
