% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calc_K}
\alias{calc_K}
\title{Calculate a single equilibrium constant}
\usage{
calc_K(
  k,
  temp_c = 25,
  sal = 35,
  p_bar = NULL,
  magnesium = 0.0528171,
  calcium = 0.0102821,
  sulphate = NULL,
  fluorine = NULL,
  method = "MyAMI"
)
}
\arguments{
\item{k}{K to be calculated}

\item{temp_c}{Temperature (Celsius)}

\item{sal}{Salinity}

\item{p_bar}{Pressure (Bar) (optional)}

\item{magnesium}{Magnesium concentration in mol/kgsw. If None, modern is assumed (0.0528171). Should be the average magnesium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{calcium}{Calcium concentration in mol/kgsw. If None, modern is assumed (0.0102821). Should be the average calcium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{sulphate}{Sulphate concentration in mol/kgsw. Calculated from salinity if not given.}

\item{fluorine}{Fluorine concentration in mol/kgsw. Calculated from salinity if not given.}

\item{method}{Options: \code{R_Polynomial}, \code{MyAMI_Polynomial} , \code{MyAMI} (defaults to "MyAMI").}
}
\value{
Specified K at the given conditions
}
\description{
Calculate a specified stoichiometric equilibrium constant at given temperature, salinity, pressure and the concentration of magnesium, calcium, sulphate, and fluorine.
}
\author{
Dennis Mayk
}
