% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.core.R
\name{Activation}
\alias{Activation}
\title{Applies an activation function to an output.}
\usage{
Activation(activation, input_shape = NULL)
}
\arguments{
\item{activation}{name of activation function to use.
See Details for possible options.}

\item{input_shape}{only need when first layer of a model;
sets the input shape of the data}
}
\description{
Applies an activation function to an output.
}
\details{
Possible activations include 'softmax', 'elu', 'softplus',
'softsign', 'relu', 'tanh', 'sigmoid', 'hard_sigmoid',
linear'. You may also set this equal to any of the
outputs from an \link{AdvancedActivation}.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(  Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  # You can also add layers directly as arguments to Sequential()

  mod <- Sequential(
    Dense(units = 50, input_shape = ncol(X_train)),
    Dropout(rate = 0.5),
    Activation("relu"),
    Dense(units = 3),
    ActivityRegularization(l1 = 1),
    Activation("softmax")
  )
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
}

if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(  Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  # You can also add layers directly as arguments to Sequential()

  mod <- Sequential(
    Dense(units = 50, input_shape = ncol(X_train)),
    Dropout(rate = 0.5),
    Activation("relu"),
    Dense(units = 3),
    ActivityRegularization(l1 = 1),
    Activation("softmax")
  )
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
}

}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other layers: \code{\link{ActivityRegularization}},
  \code{\link{AdvancedActivation}},
  \code{\link{BatchNormalization}}, \code{\link{Conv}},
  \code{\link{Dense}}, \code{\link{Dropout}},
  \code{\link{Embedding}}, \code{\link{Flatten}},
  \code{\link{GaussianNoise}}, \code{\link{LayerWrapper}},
  \code{\link{LocallyConnected}}, \code{\link{Masking}},
  \code{\link{MaxPooling}}, \code{\link{Permute}},
  \code{\link{RNN}}, \code{\link{RepeatVector}},
  \code{\link{Reshape}}, \code{\link{Sequential}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
