% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint_maxnorm}
\alias{constraint_maxnorm}
\title{MaxNorm weight constraint.}
\usage{
constraint_maxnorm(max_value = 2L, axis = 1L)
}
\arguments{
\item{max_value}{the maximum norm value for the incoming weights.}

\item{axis}{integer, axis along which to calculate weight norms.
For instance, in a \code{Dense} layer the weight matrix
has shape \verb{(input_dim, output_dim)},
set \code{axis} to \code{0} to constrain each weight vector
of length \verb{(input_dim,)}.
In a \code{Conv2D} layer with \code{data_format = "channels_last"},
the weight tensor has shape
\verb{(rows, cols, input_depth, output_depth)},
set \code{axis} to \verb{[0, 1, 2]}
to constrain the weights of each filter tensor of size
\verb{(rows, cols, input_depth)}.}
}
\value{
A \code{Constraint} instance, a callable that can be passed to layer
constructors or used directly by calling it with tensors.
}
\description{
Constrains the weights incident to each hidden unit
to have a norm less than or equal to a desired value.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/constraints#maxnorm-class}
}

Other constraints: \cr
\code{\link{Constraint}()} \cr
\code{\link{constraint_minmaxnorm}()} \cr
\code{\link{constraint_nonneg}()} \cr
\code{\link{constraint_unitnorm}()} \cr
}
\concept{constraints}
