% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_shuffle}
\alias{random_shuffle}
\title{Shuffle the elements of a tensor uniformly at random along an axis.}
\usage{
random_shuffle(x, axis = 1L, seed = NULL)
}
\arguments{
\item{x}{The tensor to be shuffled.}

\item{axis}{An integer specifying the axis along which to shuffle. Defaults to
\code{0}.}

\item{seed}{An R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{\link[=random_seed_generator]{random_seed_generator()}}.}
}
\value{
A tensor, a copy of \code{x} with the \code{axis} axis shuffled.
}
\description{
Shuffle the elements of a tensor uniformly at random along an axis.
}
\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
