% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_sparse_categorical_crossentropy}
\alias{loss_sparse_categorical_crossentropy}
\title{Computes the crossentropy loss between the labels and predictions.}
\usage{
loss_sparse_categorical_crossentropy(
  y_true,
  y_pred,
  from_logits = FALSE,
  ignore_class = NULL,
  axis = -1L,
  ...,
  reduction = "sum_over_batch_size",
  name = "sparse_categorical_crossentropy"
)
}
\arguments{
\item{y_true}{Ground truth values.}

\item{y_pred}{The predicted values.}

\item{from_logits}{Whether \code{y_pred} is expected to be a logits tensor. By
default, we assume that \code{y_pred} encodes a probability distribution.}

\item{ignore_class}{Optional integer. The ID of a class to be ignored during
loss computation. This is useful, for example, in segmentation
problems featuring a "void" class (commonly -1 or 255) in
segmentation maps. By default (\code{ignore_class=NULL}), all classes are
considered.}

\item{axis}{Defaults to \code{-1}. The dimension along which the entropy is
computed.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}.
Supported options are \code{"sum"}, \code{"sum_over_batch_size"} or \code{NULL}.}

\item{name}{Optional name for the loss instance.}
}
\value{
Sparse categorical crossentropy loss value.
}
\description{
Use this crossentropy loss function when there are two or more label
classes.  We expect labels to be provided as integers. If you want to
provide labels using \code{one-hot} representation, please use
\code{CategoricalCrossentropy} loss.  There should be \verb{# classes} floating point
values per feature for \code{y_pred} and a single floating point value per
feature for \code{y_true}.

In the snippet below, there is a single floating point value per example for
\code{y_true} and \code{num_classes} floating pointing values per example for
\code{y_pred}. The shape of \code{y_true} is \verb{[batch_size]} and the shape of \code{y_pred}
is \verb{[batch_size, num_classes]}.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- c(1, 2)
y_pred <- rbind(c(0.05, 0.95, 0), c(0.1, 0.8, 0.1))
loss <- loss_sparse_categorical_crossentropy(y_true, y_pred)
loss
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0.05129339 2.30258509], shape=(2), dtype=float64)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- c(1, 2)
y_pred <- rbind(c(0.05, 0.95, 0), c(0.1, 0.8, 0.1))
# Using 'auto'/'sum_over_batch_size' reduction type.
scce <- loss_sparse_categorical_crossentropy()
scce(op_array(y_true), op_array(y_pred))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(1.1769392, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# 1.177
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Calling with 'sample_weight'.
scce(op_array(y_true), op_array(y_pred), sample_weight = op_array(c(0.3, 0.7)))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.8135988, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Using 'sum' reduction type.
scce <- loss_sparse_categorical_crossentropy(reduction="sum")
scce(op_array(y_true), op_array(y_pred))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(2.3538785, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# 2.354
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Using 'none' reduction type.
scce <- loss_sparse_categorical_crossentropy(reduction=NULL)
scce(op_array(y_true), op_array(y_pred))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0.05129344 2.3025851 ], shape=(2), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# array([0.0513, 2.303], dtype=float32)
}\if{html}{\out{</div>}}

Usage with the \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model \%>\% compile(optimizer = 'sgd',
                  loss = loss_sparse_categorical_crossentropy())
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/losses/probabilistic_losses#sparsecategoricalcrossentropy-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
