% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-aliases.R
\name{bidirectional}
\alias{bidirectional}
\title{layer_bidirectional}
\usage{
bidirectional(
  object,
  layer,
  merge_mode = "concat",
  weights = NULL,
  backward_layer = NULL,
  ...
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{layer}{\code{RNN} instance, such as
\code{\link[=layer_lstm]{layer_lstm()}} or \code{\link[=layer_gru]{layer_gru()}}.
It could also be a \code{\link[=Layer]{Layer()}} instance
that meets the following criteria:
\enumerate{
\item Be a sequence-processing layer (accepts 3D+ inputs).
\item Have a \code{go_backwards}, \code{return_sequences} and \code{return_state}
attribute (with the same semantics as for the \code{RNN} class).
\item Have an \code{input_spec} attribute.
\item Implement serialization via \code{get_config()} and \code{from_config()}.
Note that the recommended way to create new RNN layers is to write a
custom RNN cell and use it with \code{\link[=layer_rnn]{layer_rnn()}}, instead of
subclassing with \code{\link[=Layer]{Layer()}} directly.
When \code{return_sequences} is \code{TRUE}, the output of the masked
timestep will be zero regardless of the layer's original
\code{zero_output_for_mask} value.
}}

\item{merge_mode}{Mode by which outputs of the forward and backward RNNs
will be combined. One of \verb{\{"sum", "mul", "concat", "ave", NULL\}}.
If \code{NULL}, the outputs will not be combined,
they will be returned as a list. Defaults to \code{"concat"}.}

\item{weights}{see description}

\item{backward_layer}{Optional \code{RNN},
or \code{Layer()} instance to be used to handle
backwards input processing.
If \code{backward_layer} is not provided, the layer instance passed
as the \code{layer} argument will be used to generate the backward layer
automatically.
Note that the provided \code{backward_layer} layer should have properties
matching those of the \code{layer} argument, in particular
it should have the same values for \code{stateful}, \code{return_states},
\code{return_sequences}, etc. In addition, \code{backward_layer}
and \code{layer} should have different \code{go_backwards} argument values.
A \code{ValueError} will be raised if these requirements are not met.}

\item{...}{For forward/backward compatability.}
}
\value{
The return value depends on the value provided for the first argument.
If  \code{object} is:
\itemize{
\item a \code{keras_model_sequential()}, then the layer is added to the sequential model
(which is modified in place). To enable piping, the sequential model is also
returned, invisibly.
\item a \code{keras_input()}, then the output tensor from calling \code{layer(input)} is returned.
\item \code{NULL} or missing, then a \code{Layer} instance is returned.
}
}
\description{
\code{bidirectional()} is an alias for \code{\link[=layer_bidirectional]{layer_bidirectional()}}.
See \verb{?}\code{\link[=layer_bidirectional]{layer_bidirectional()}} for the full documentation.
}
\keyword{internal}
