% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_permute}
\alias{layer_permute}
\title{Permute the dimensions of an input according to a given pattern}
\usage{
layer_permute(
  object,
  dims,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{dims}{List of integers. Permutation pattern, does not include the
samples dimension. Indexing starts at 1. For instance, \verb{(2, 1)} permutes
the first and second dimension of the input.}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Permute the dimensions of an input according to a given pattern
}
\note{
Useful for e.g. connecting RNNs and convnets together.
}
\section{Input and Output Shapes}{


Input shape: Arbitrary

Output shape: Same as the input shape, but with the dimensions re-ordered
according to the specified pattern.
}

\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_attention}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dense}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{core layers}
