% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-activations.R
\name{layer_activation_leaky_relu}
\alias{layer_activation_leaky_relu}
\title{Leaky version of a Rectified Linear Unit.}
\usage{
layer_activation_leaky_relu(object, alpha = 0.3, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{alpha}{float >= 0. Negative slope coefficient.}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Allows a small gradient when the unit is not active: \code{f(x) = alpha * x} for
\code{x < 0}, \code{f(x) = x} for \code{x >= 0}.
}
\seealso{
\href{https://ai.stanford.edu/~amaas/papers/relu_hybrid_icml2013_final.pdf}{Rectifier Nonlinearities Improve Neural Network AcousticModels}.

Other activation layers: \code{\link{layer_activation_elu}},
  \code{\link{layer_activation_parametric_relu}},
  \code{\link{layer_activation_thresholded_relu}},
  \code{\link{layer_activation}}
}
