% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyNumberCalculation.R
\name{calcSmoothCopyNumber}
\alias{calcSmoothCopyNumber}
\title{Smooth copy number values across chromosomes and chromosome arms}
\usage{
calcSmoothCopyNumber(TapestriExperiment, method = "median")
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{method}{Character, smoothing method: median (default) or mean.}
}
\value{
\code{TapestriExperiment} with \code{smoothedCopyNumber} and \code{discreteCopyNumber} assays in \code{altExp} slots \code{smoothedCopyNumberByChr} and \code{smoothedCopyNumberByArm}.
}
\description{
\code{calcSmoothCopyNumber()} takes \code{copyNumber} slot values for probes on a chromosome and smooths them by median (default) for each chromosome
and chromosome arm, resulting in one copy number value per chromosome and chromosome arm for each cell barcode.
Cell-chromosome values are then discretized into integers by conventional rounding (1.5 <= x < 2.5 rounds to 2).
Smoothed copy number and discretized smoothed copy number values are stored as \code{smoothedCopyNumber} and \code{discreteCopyNumber} assays,
in \code{altExp} slots \code{smoothedCopyNumberByChr} for chromosome-level smoothing, and \code{smoothedCopyNumberByArm} for chromosome arm-level smoothing.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- calcNormCounts(tap.object)
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
tap.object <- calcCopyNumber(tap.object,
  control.copy.number,
  sample.feature = "test.cluster"
)
tap.object <- calcSmoothCopyNumber(tap.object)
}
\concept{copy number}
